/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.model.contracts.repository;

import com.mulesoft.mule.runtime.gw.api.contract.Contract;
import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.folders.PolicyFolders;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor;
import com.mulesoft.mule.runtime.gw.config.ContractsRepositoryConfiguration;
import com.mulesoft.mule.runtime.gw.model.contracts.repository.ContractRepository;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mule.runtime.core.api.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDBContractRepository
implements ContractRepository {
    public static final String DB_FILE_NAME = "api-contracts.db";
    private static final Logger LOGGER = LoggerFactory.getLogger(MapDBContractRepository.class);
    private static DB db;
    private final ContractsRepositoryConfiguration repositoryConfiguration = new ContractsRepositoryConfiguration();

    public static File getDbFile() {
        return new File(PolicyFolders.getPoliciesFolder(), DB_FILE_NAME);
    }

    private <T> void storeGeneric(String key, Collection<T> contracts) {
        this.withContainerClassLoader(() -> {
            LOGGER.debug("Storing {} under key {}.", (Object)contracts, (Object)key);
            this.initDbIfNecessary();
            try {
                Set set;
                try {
                    set = db.createHashSet(key).makeOrGet();
                    set.clear();
                }
                catch (Throwable e) {
                    this.closeDb();
                    LOGGER.error("Error on API {}. Deleting local contract database... it will be fully regenerated on the next polling cycle. {}", (Object)key, (Object)ExceptionDescriptor.errorMessage(e));
                    this.deleteDBFiles();
                    this.initDbIfNecessary();
                    set = db.createHashSet(key).make();
                }
                set.addAll(contracts);
                db.commit();
                LOGGER.debug("Successfully stored under key {}.", (Object)key);
            }
            catch (Throwable e) {
                db.rollback();
                LOGGER.error("Error persisting contracts for API {}. {}", (Object)key, (Object)ExceptionDescriptor.errorMessage(e));
            }
        });
    }

    @Override
    public void store(ApiKey apiKey, Collection<Contract> contracts) {
        LOGGER.debug("Storing Contracts for api {}.", (Object)apiKey);
        this.storeGeneric(this.contractKey(apiKey), contracts);
    }

    @Override
    public void storeSlas(ApiKey apiKey, Collection<Sla> slas) {
        LOGGER.debug("Storing SLAs for api {}.", (Object)apiKey);
        this.storeGeneric(this.slaKey(apiKey), slas);
    }

    @Override
    public Set<Contract> load(ApiKey apiKey) {
        String key = this.contractKey(apiKey);
        return this.withContainerClassLoader(() -> {
            try {
                if (this.isDbPresent()) {
                    this.initDbIfNecessary();
                    if (db.exists(key)) {
                        return new HashSet(db.createHashSet(key).makeOrGet());
                    }
                }
            }
            catch (Throwable e) {
                LOGGER.warn("There was an error reading stored contracts. {}. DB recovery will be attempted.", (Object)ExceptionDescriptor.errorMessage(e));
                this.restartDb();
            }
            return new HashSet();
        });
    }

    @Override
    public void delete(ApiKey apiKey) {
        this.withContainerClassLoader(() -> {
            if (this.isDbPresent()) {
                this.initDbIfNecessary();
                try {
                    db.delete(this.contractKey(apiKey));
                    db.delete(this.slaKey(apiKey));
                    db.commit();
                }
                catch (Throwable e) {
                    db.rollback();
                    LOGGER.error("Error deleting contracts from API {}. {}", (Object)apiKey.id(), (Object)ExceptionDescriptor.errorMessage(e));
                }
                try {
                    if (db.getAll().isEmpty()) {
                        this.closeDb();
                        this.deleteDBFiles();
                    }
                }
                catch (Throwable e) {
                    LOGGER.warn("Error checking DB is empty: {}. DB recovery will be attempted.", (Object)ExceptionDescriptor.errorMessage(e));
                    this.restartDb();
                }
            }
        });
    }

    @Override
    public boolean contains(ApiKey apiKey) {
        boolean result = false;
        try {
            result = this.containsKey(this.contractKey(apiKey));
        }
        catch (Throwable e) {
            LOGGER.warn("Error checking if contracts are present for API {}. {}. DB recovery will be attempted.", (Object)apiKey, (Object)ExceptionDescriptor.errorMessage(e));
            this.restartDb();
        }
        LOGGER.debug("Check if contracts are present for api {}. Result: {}.", (Object)apiKey, (Object)result);
        return result;
    }

    @Override
    public boolean containsSla(ApiKey apiKey) {
        boolean result = false;
        try {
            result = this.containsKey(this.slaKey(apiKey));
        }
        catch (Throwable e) {
            LOGGER.warn("Error checking if SLAs are present for API {}. {}. DB recovery will be attempted.", (Object)apiKey, (Object)ExceptionDescriptor.errorMessage(e));
            this.restartDb();
        }
        LOGGER.debug("Check if SLAs are present for api {}. Result: {}.", (Object)apiKey, (Object)result);
        return result;
    }

    private boolean containsKey(String key) {
        return this.withContainerClassLoader(() -> {
            if (this.isDbPresent()) {
                this.initDbIfNecessary();
                return db.exists(key);
            }
            return false;
        });
    }

    public void dispose() {
        this.withContainerClassLoader(() -> {
            try {
                this.closeDb();
                db = null;
            }
            catch (Throwable e) {
                LOGGER.error("Error disposing db: {}", (Object)ExceptionDescriptor.errorMessage(e));
            }
        });
    }

    @Override
    public void compact() {
        this.withContainerClassLoader(() -> {
            if (this.isDbPresent()) {
                this.initDbIfNecessary();
                try {
                    db.compact();
                }
                catch (Throwable e) {
                    LOGGER.warn("Error compacting DB: {}. DB recovery will be attempted.", (Object)ExceptionDescriptor.errorMessage(e));
                    this.restartDb();
                }
            }
        });
    }

    private void initDbIfNecessary() {
        if (db == null || db.isClosed()) {
            this.initDb();
        }
    }

    private boolean isDbPresent() {
        return MapDBContractRepository.getDbFile().exists();
    }

    private void initDb() {
        db = DBMaker.newFileDB((File)MapDBContractRepository.getDbFile()).sizeLimit((double)this.repositoryConfiguration.getContractsRepositoryCapacity()).closeOnJvmShutdown().make();
    }

    private void closeDb() {
        if (db != null && !db.isClosed()) {
            try {
                db.close();
            }
            catch (Throwable e) {
                LOGGER.error("Error closing the db: {}", (Object)ExceptionDescriptor.errorMessage(e));
            }
        }
    }

    private void deleteDBFiles() {
        Arrays.asList(PolicyFolders.getPoliciesFolder().listFiles((dir, name) -> name.startsWith(DB_FILE_NAME))).forEach(File::delete);
    }

    private void withContainerClassLoader(Runnable runnable) {
        ClassUtils.withContextClassLoader((ClassLoader)this.getClass().getClassLoader(), (Runnable)runnable);
    }

    private <T> T withContainerClassLoader(Callable<T> callable) {
        return (T)ClassUtils.withContextClassLoader((ClassLoader)this.getClass().getClassLoader(), callable);
    }

    public boolean equals(Object o) {
        return o != null && o instanceof MapDBContractRepository;
    }

    public int hashCode() {
        return db != null ? db.hashCode() : 0;
    }

    private String contractKey(ApiKey key) {
        return key.id().toString();
    }

    private String slaKey(ApiKey key) {
        return this.contractKey(key) + "-sla";
    }

    private void restartDb() {
        LOGGER.debug("Restarting DB due to error in previous DB state.");
        this.dispose();
        this.deleteDBFiles();
        this.initDbIfNecessary();
        LOGGER.info("DB was recovered successfully.");
    }
}

