/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.params;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class SequenceInfo {
    private static final Pattern RE_ADDITIONAL = Pattern.compile("^\\s*wrapper\\.java\\.additional\\.(\\d+).+");
    private static final Pattern RE_CLASSPATH = Pattern.compile("^\\s*wrapper\\.java\\.classpath\\.(\\d+).+");
    private final HighestSequenceTracker additionalParamSeqTracker = new HighestSequenceTracker(RE_ADDITIONAL);
    private final HighestSequenceTracker classpathSeqTracker = new HighestSequenceTracker(RE_CLASSPATH);

    SequenceInfo() {
    }

    public void feedLine(String line) {
        this.additionalParamSeqTracker.feedLine(line);
        this.classpathSeqTracker.feedLine(line);
    }

    public String reSequenceLine(String line) {
        return this.additionalParamSeqTracker.reSequenceLine(line).orElseGet(() -> this.classpathSeqTracker.reSequenceLine(line).orElse(line));
    }

    private static class HighestSequenceTracker {
        private int highestSequence = 0;
        private final Map<String, Integer> reSequenced = new HashMap<String, Integer>();
        private final Pattern lookupPattern;

        private HighestSequenceTracker(Pattern lookupPattern) {
            this.lookupPattern = lookupPattern;
        }

        public void feedLine(String line) {
            Matcher matcher = this.lookupPattern.matcher(line);
            if (matcher.find()) {
                this.highestSequence = Math.max(this.highestSequence, Integer.parseInt(matcher.group(1)));
            }
        }

        public Optional<String> reSequenceLine(String line) {
            Matcher matcher = this.lookupPattern.matcher(line);
            StringBuilder sb = new StringBuilder();
            if (matcher.find()) {
                String foundSequence = matcher.group(1);
                Integer assignedSequence = this.reSequenced.computeIfAbsent(foundSequence, k -> ++this.highestSequence);
                sb.append(line, 0, matcher.start(1));
                sb.append(assignedSequence);
                sb.append(line, matcher.end(1), line.length());
                return Optional.of(sb.toString());
            }
            return Optional.empty();
        }
    }
}

