/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.platform.interaction.keepalive;

import com.mulesoft.mule.runtime.gw.api.config.GateKeeperConfiguration;
import com.mulesoft.mule.runtime.gw.client.dto.keepalive.GateKeeperStatusDto;
import com.mulesoft.mule.runtime.gw.client.dto.keepalive.KeepAliveDto;
import com.mulesoft.mule.runtime.gw.client.dto.keepalive.PolicyStatusDto;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.gatekeeper.status.GatekeeperStatus;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentTracker;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class KeepAlivePayloadFactory {
    private static final GateKeeperStatusDto DISABLED = new GateKeeperStatusDto(false, "DISABLED");
    private final PolicyDeploymentTracker policyDeploymentTracker;
    private final ApiTrackingService apiTrackingService;
    private final GateKeeperConfiguration gateKeeperConfiguration;

    public KeepAlivePayloadFactory(ApiTrackingService apiTrackingService, PolicyDeploymentTracker policyDeploymentTracker, GateKeeperConfiguration gateKeeperConfiguration) {
        this.policyDeploymentTracker = policyDeploymentTracker;
        this.apiTrackingService = apiTrackingService;
        this.gateKeeperConfiguration = gateKeeperConfiguration;
    }

    public KeepAliveDto create(Api api) throws IOException {
        return new KeepAliveDto(this.gatekeeper(api), this.policies(api), this.contracts(api));
    }

    private GateKeeperStatusDto gatekeeper(Api api) {
        if (this.gateKeeperConfiguration.isEnabled()) {
            GatekeeperStatus status = api.getImplementation().gatekeeperStatus().status();
            return new GateKeeperStatusDto(status.isBlocked(), status.name());
        }
        return DISABLED;
    }

    private List<PolicyStatusDto> policies(Api api) {
        LinkedList<PolicyStatusDto> policies = new LinkedList<PolicyStatusDto>();
        for (PolicyDeploymentStatus policy : this.policyDeploymentTracker.policyStatuses(api.getKey())) {
            PolicyDefinition definition = policy.getLatestPolicyStatus().getPolicyDefinition();
            String id = definition.getId();
            boolean online = definition.isOnline();
            String targetVersion = definition.getVersion();
            String deploymentStatus = policy.getLatestPolicyStatus().deploymentStatus().name();
            String currentVersion = policy.getAppliedPolicyStatus().map(p -> p.getPolicyDefinition().getVersion()).orElse(null);
            policies.add(new PolicyStatusDto(id, online, targetVersion, currentVersion, deploymentStatus));
        }
        return policies;
    }

    private String contracts(Api api) {
        String contractsTag = null;
        if (this.apiTrackingService.getTrackedApisRequiringContracts().contains(api)) {
            contractsTag = api.getTrackingInfo().getContractsEntityTag();
            contractsTag = contractsTag == null ? "" : contractsTag;
        }
        return contractsTag;
    }
}

