/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.yagi.framework.grammar.rule.ConditionalRule;
import org.raml.yagi.framework.grammar.rule.DefaultValue;
import org.raml.yagi.framework.grammar.rule.KeyValueRule;
import org.raml.yagi.framework.grammar.rule.LiteralDefaultValue;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.util.NodeSelector;

public class ConditionalRules {
    private List<String> selectorExpression;
    private List<ConditionalRule> options;
    private DefaultValue defaultValue;

    public ConditionalRules(List<String> selectorExpression, ConditionalRule ... cases) {
        this.selectorExpression = selectorExpression;
        this.options = Arrays.asList(cases);
    }

    @Nonnull
    public List<KeyValueRule> getRulesNode(Node node) {
        Node from = this.selectValue(node);
        if (from == null && this.defaultValue != null) {
            from = this.defaultValue.getDefaultValue(node);
        }
        if (from != null) {
            for (ConditionalRule option : this.options) {
                if (!option.matches(from)) continue;
                return option.getRules();
            }
        }
        return Collections.emptyList();
    }

    public List<? extends Rule> getChildren() {
        ArrayList<KeyValueRule> result = new ArrayList<KeyValueRule>();
        for (ConditionalRule option : this.options) {
            result.addAll(new ArrayList<KeyValueRule>(option.getRules()));
        }
        return result;
    }

    @Nullable
    private Node selectValue(Node node) {
        for (String expr : this.selectorExpression) {
            Node from = NodeSelector.selectFrom(expr, node);
            if (from == null) continue;
            return from;
        }
        return null;
    }

    public ConditionalRules defaultValue(DefaultValue defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public ConditionalRules defaultValue(Node defaultValue) {
        this.defaultValue = new LiteralDefaultValue(defaultValue);
        return this;
    }
}

