/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.query;

import com.hazelcast.aggregation.Aggregator;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.FutureUtil;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.internal.util.executor.ManagedExecutorService;
import com.hazelcast.map.impl.query.AccumulationExecutor;
import com.hazelcast.map.impl.query.AggregationResult;
import com.hazelcast.query.impl.QueryableEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class ParallelAccumulationExecutor
implements AccumulationExecutor {
    private static final int THREAD_SPLIT_COUNT = 8;
    private final ManagedExecutorService executor;
    private final SerializationService serializationService;
    private final int callTimeoutInMillis;

    public ParallelAccumulationExecutor(ManagedExecutorService executor, SerializationService serializationService, int callTimeoutInMillis) {
        this.executor = executor;
        this.serializationService = serializationService;
        this.callTimeoutInMillis = callTimeoutInMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AggregationResult execute(Aggregator aggregator, Iterable<QueryableEntry> entries, PartitionIdSet partitionIds) {
        Collection<Aggregator> chunkAggregators = this.accumulateParallel(aggregator, entries);
        Aggregator resultAggregator = this.clone(aggregator);
        try {
            for (Aggregator chunkAggregator : chunkAggregators) {
                resultAggregator.combine(chunkAggregator);
            }
        }
        finally {
            resultAggregator.onCombinationFinished();
        }
        AggregationResult result = new AggregationResult(resultAggregator, this.serializationService);
        result.setPartitionIds(partitionIds);
        return result;
    }

    protected Collection<Aggregator> accumulateParallel(Aggregator aggregator, Iterable<QueryableEntry> entries) {
        ArrayList futures = new ArrayList();
        ArrayList buffer = new ArrayList<QueryableEntry>();
        for (QueryableEntry entry : entries) {
            buffer.add(entry);
            if (buffer.size() != 8) continue;
            futures.add(this.executor.submit(new AccumulatePartitionCallable(this.clone(aggregator), buffer)));
            buffer = new ArrayList();
        }
        if (!buffer.isEmpty()) {
            futures.add(this.executor.submit(new AccumulatePartitionCallable(this.clone(aggregator), buffer)));
        }
        return FutureUtil.returnWithDeadline(futures, this.callTimeoutInMillis, TimeUnit.MILLISECONDS, FutureUtil.RETHROW_EVERYTHING);
    }

    private Aggregator clone(Aggregator aggregator) {
        return (Aggregator)this.serializationService.toObject(this.serializationService.toData(aggregator));
    }

    private static final class AccumulatePartitionCallable
    implements Callable<Aggregator> {
        private final Aggregator aggregator;
        private final Iterable<QueryableEntry> entries;

        private AccumulatePartitionCallable(Aggregator aggregator, Iterable<QueryableEntry> entries) {
            this.aggregator = aggregator;
            this.entries = entries;
        }

        @Override
        public Aggregator call() {
            try {
                for (QueryableEntry entry : this.entries) {
                    this.aggregator.accumulate(entry);
                }
            }
            finally {
                this.aggregator.onAccumulationFinished();
            }
            return this.aggregator;
        }
    }
}

