/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class PortableUtil {
    private PortableUtil() {
    }

    public static void writeLocalTime(ObjectDataOutput out, LocalTime value) throws IOException {
        int hour = value.getHour();
        int minute = value.getMinute();
        int second = value.getSecond();
        int nano = value.getNano();
        out.writeByte(hour);
        out.writeByte(minute);
        out.writeByte(second);
        out.writeInt(nano);
    }

    public static LocalTime readLocalTime(ObjectDataInput in) throws IOException {
        byte hour = in.readByte();
        byte minute = in.readByte();
        byte second = in.readByte();
        int nano = in.readInt();
        return LocalTime.of(hour, minute, second, nano);
    }

    public static void writeLocalDate(ObjectDataOutput out, LocalDate value) throws IOException {
        int year = value.getYear();
        int monthValue = value.getMonthValue();
        int dayOfMonth = value.getDayOfMonth();
        out.writeShort(year);
        out.writeByte(monthValue);
        out.writeByte(dayOfMonth);
    }

    public static LocalDate readLocalDate(ObjectDataInput in) throws IOException {
        short year = in.readShort();
        byte month = in.readByte();
        byte dayOfMonth = in.readByte();
        return LocalDate.of((int)year, month, (int)dayOfMonth);
    }

    public static void writeLocalDateTime(ObjectDataOutput out, LocalDateTime value) throws IOException {
        PortableUtil.writeLocalDate(out, value.toLocalDate());
        PortableUtil.writeLocalTime(out, value.toLocalTime());
    }

    public static LocalDateTime readLocalDateTime(ObjectDataInput in) throws IOException {
        short year = in.readShort();
        byte month = in.readByte();
        byte dayOfMonth = in.readByte();
        byte hour = in.readByte();
        byte minute = in.readByte();
        byte second = in.readByte();
        int nano = in.readInt();
        return LocalDateTime.of((int)year, month, (int)dayOfMonth, (int)hour, (int)minute, (int)second, nano);
    }

    public static void writeOffsetDateTime(ObjectDataOutput out, OffsetDateTime value) throws IOException {
        PortableUtil.writeLocalDate(out, value.toLocalDate());
        PortableUtil.writeLocalTime(out, value.toLocalTime());
        ZoneOffset offset = value.getOffset();
        int totalSeconds = offset.getTotalSeconds();
        out.writeInt(totalSeconds);
    }

    public static OffsetDateTime readOffsetDateTime(ObjectDataInput in) throws IOException {
        short year = in.readShort();
        byte month = in.readByte();
        byte dayOfMonth = in.readByte();
        byte hour = in.readByte();
        byte minute = in.readByte();
        byte second = in.readByte();
        int nano = in.readInt();
        int zoneTotalSeconds = in.readInt();
        ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(zoneTotalSeconds);
        return OffsetDateTime.of(year, month, dayOfMonth, hour, minute, second, nano, zoneOffset);
    }
}

