/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.nearcache.NearCacheStats;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.LongAccumulator;

public class NearCacheStatsImpl
implements NearCacheStats {
    private static final double PERCENTAGE = 100.0;
    private static final AtomicLongFieldUpdater<NearCacheStatsImpl> OWNED_ENTRY_COUNT = AtomicLongFieldUpdater.newUpdater(NearCacheStatsImpl.class, "ownedEntryCount");
    private static final AtomicLongFieldUpdater<NearCacheStatsImpl> OWNED_ENTRY_MEMORY_COST = AtomicLongFieldUpdater.newUpdater(NearCacheStatsImpl.class, "ownedEntryMemoryCost");
    private static final AtomicLongFieldUpdater<NearCacheStatsImpl> EVICTIONS = AtomicLongFieldUpdater.newUpdater(NearCacheStatsImpl.class, "evictions");
    private static final AtomicLongFieldUpdater<NearCacheStatsImpl> EXPIRATIONS = AtomicLongFieldUpdater.newUpdater(NearCacheStatsImpl.class, "expirations");
    private static final AtomicLongFieldUpdater<NearCacheStatsImpl> INVALIDATIONS = AtomicLongFieldUpdater.newUpdater(NearCacheStatsImpl.class, "invalidations");
    private static final AtomicLongFieldUpdater<NearCacheStatsImpl> INVALIDATION_REQUESTS = AtomicLongFieldUpdater.newUpdater(NearCacheStatsImpl.class, "invalidationRequests");
    private static final AtomicLongFieldUpdater<NearCacheStatsImpl> PERSISTENCE_COUNT = AtomicLongFieldUpdater.newUpdater(NearCacheStatsImpl.class, "persistenceCount");
    @Probe(name="creationTime", unit=ProbeUnit.MS)
    private final long creationTime;
    @Probe(name="ownedEntryCount")
    private volatile long ownedEntryCount;
    @Probe(name="ownedEntryMemoryCost", unit=ProbeUnit.BYTES)
    private volatile long ownedEntryMemoryCost;
    @Probe(name="hits")
    private final LongAccumulator hits = new LongAccumulator(Long::sum, 0L);
    @Probe(name="misses")
    private final LongAccumulator misses = new LongAccumulator(Long::sum, 0L);
    @Probe(name="evictions")
    private volatile long evictions;
    @Probe(name="expirations")
    private volatile long expirations;
    @Probe(name="invalidations")
    private volatile long invalidations;
    @Probe(name="invalidationRequests")
    private volatile long invalidationRequests;
    @Probe(name="persistenceCount")
    private volatile long persistenceCount;
    @Probe(name="lastPersistenceTime", unit=ProbeUnit.MS)
    private volatile long lastPersistenceTime;
    @Probe(name="lastPersistenceDuration", unit=ProbeUnit.MS)
    private volatile long lastPersistenceDuration;
    @Probe(name="lastPersistenceWrittenBytes", unit=ProbeUnit.BYTES)
    private volatile long lastPersistenceWrittenBytes;
    @Probe(name="lastPersistenceKeyCount")
    private volatile long lastPersistenceKeyCount;
    private volatile String lastPersistenceFailure = "";

    public NearCacheStatsImpl() {
        this.creationTime = NearCacheStatsImpl.getNowInMillis();
    }

    public NearCacheStatsImpl(NearCacheStats stats) {
        this.creationTime = stats.getCreationTime();
        this.ownedEntryCount = stats.getOwnedEntryCount();
        this.ownedEntryMemoryCost = stats.getOwnedEntryMemoryCost();
        this.setHits(stats.getHits());
        this.setMisses(stats.getMisses());
        this.evictions = stats.getEvictions();
        this.expirations = stats.getExpirations();
        this.invalidations = stats.getInvalidations();
        this.invalidationRequests = stats.getInvalidationRequests();
        this.persistenceCount = stats.getPersistenceCount();
        this.lastPersistenceTime = stats.getLastPersistenceTime();
        this.lastPersistenceDuration = stats.getLastPersistenceDuration();
        this.lastPersistenceWrittenBytes = stats.getLastPersistenceWrittenBytes();
        this.lastPersistenceKeyCount = stats.getLastPersistenceKeyCount();
        this.lastPersistenceFailure = stats.getLastPersistenceFailure();
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getOwnedEntryCount() {
        return this.ownedEntryCount;
    }

    public void setOwnedEntryCount(long ownedEntryCount) {
        OWNED_ENTRY_COUNT.set(this, ownedEntryCount);
    }

    public void incrementOwnedEntryCount() {
        OWNED_ENTRY_COUNT.incrementAndGet(this);
    }

    public void decrementOwnedEntryCount() {
        OWNED_ENTRY_COUNT.decrementAndGet(this);
    }

    @Override
    public long getOwnedEntryMemoryCost() {
        return this.ownedEntryMemoryCost;
    }

    public void setOwnedEntryMemoryCost(long ownedEntryMemoryCost) {
        OWNED_ENTRY_MEMORY_COST.set(this, ownedEntryMemoryCost);
    }

    public void incrementOwnedEntryMemoryCost(long ownedEntryMemoryCost) {
        OWNED_ENTRY_MEMORY_COST.addAndGet(this, ownedEntryMemoryCost);
    }

    public void decrementOwnedEntryMemoryCost(long ownedEntryMemoryCost) {
        OWNED_ENTRY_MEMORY_COST.addAndGet(this, -ownedEntryMemoryCost);
    }

    @Override
    public long getHits() {
        return this.hits.longValue();
    }

    void setHits(long hits) {
        this.hits.reset();
        this.hits.accumulate(hits);
    }

    public void incrementHits() {
        this.hits.accumulate(1L);
    }

    @Override
    public long getMisses() {
        return this.misses.longValue();
    }

    void setMisses(long misses) {
        this.misses.reset();
        this.misses.accumulate(misses);
    }

    public void incrementMisses() {
        this.misses.accumulate(1L);
    }

    @Override
    public double getRatio() {
        if (this.misses.get() == 0L) {
            if (this.hits.get() == 0L) {
                return Double.NaN;
            }
            return Double.POSITIVE_INFINITY;
        }
        return this.hits.doubleValue() / this.misses.doubleValue() * 100.0;
    }

    @Override
    public long getEvictions() {
        return this.evictions;
    }

    public void incrementEvictions() {
        EVICTIONS.incrementAndGet(this);
    }

    @Override
    public long getExpirations() {
        return this.expirations;
    }

    public void incrementExpirations() {
        EXPIRATIONS.incrementAndGet(this);
    }

    @Override
    public long getInvalidations() {
        return this.invalidations;
    }

    public void incrementInvalidations() {
        INVALIDATIONS.incrementAndGet(this);
    }

    public void incrementInvalidations(long delta) {
        INVALIDATIONS.addAndGet(this, delta);
    }

    @Override
    public long getInvalidationRequests() {
        return this.invalidationRequests;
    }

    public void incrementInvalidationRequests() {
        INVALIDATION_REQUESTS.incrementAndGet(this);
    }

    public void resetInvalidationEvents() {
        INVALIDATION_REQUESTS.set(this, 0L);
    }

    @Override
    public long getPersistenceCount() {
        return this.persistenceCount;
    }

    public void addPersistence(long duration, int writtenBytes, int keyCount) {
        PERSISTENCE_COUNT.incrementAndGet(this);
        this.lastPersistenceTime = NearCacheStatsImpl.getNowInMillis();
        this.lastPersistenceDuration = duration;
        this.lastPersistenceWrittenBytes = writtenBytes;
        this.lastPersistenceKeyCount = keyCount;
        this.lastPersistenceFailure = "";
    }

    public void addPersistenceFailure(Throwable t) {
        PERSISTENCE_COUNT.incrementAndGet(this);
        this.lastPersistenceTime = NearCacheStatsImpl.getNowInMillis();
        this.lastPersistenceDuration = 0L;
        this.lastPersistenceWrittenBytes = 0L;
        this.lastPersistenceKeyCount = 0L;
        this.lastPersistenceFailure = t.getClass().getSimpleName() + ": " + t.getMessage();
    }

    private static long getNowInMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public long getLastPersistenceTime() {
        return this.lastPersistenceTime;
    }

    @Override
    public long getLastPersistenceDuration() {
        return this.lastPersistenceDuration;
    }

    @Override
    public long getLastPersistenceWrittenBytes() {
        return this.lastPersistenceWrittenBytes;
    }

    @Override
    public long getLastPersistenceKeyCount() {
        return this.lastPersistenceKeyCount;
    }

    @Override
    public String getLastPersistenceFailure() {
        return this.lastPersistenceFailure;
    }

    public String toString() {
        return "NearCacheStatsImpl{ownedEntryCount=" + this.ownedEntryCount + ", ownedEntryMemoryCost=" + this.ownedEntryMemoryCost + ", creationTime=" + this.creationTime + ", hits=" + this.hits + ", misses=" + this.misses + ", ratio=" + String.format("%.1f%%", this.getRatio()) + ", evictions=" + this.evictions + ", expirations=" + this.expirations + ", invalidations=" + this.invalidations + ", invalidationRequests=" + this.invalidationRequests + ", lastPersistenceTime=" + this.lastPersistenceTime + ", persistenceCount=" + this.persistenceCount + ", lastPersistenceDuration=" + this.lastPersistenceDuration + ", lastPersistenceWrittenBytes=" + this.lastPersistenceWrittenBytes + ", lastPersistenceKeyCount=" + this.lastPersistenceKeyCount + ", lastPersistenceFailure='" + this.lastPersistenceFailure + "'}";
    }
}

