/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.value;

import java.util.Set;
import javax.inject.Inject;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.api.value.ValueProviderService;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.core.internal.util.LocationUtils;
import org.mule.runtime.extension.api.values.ComponentValueProvider;
import org.mule.runtime.extension.api.values.ConfigurationParameterValueProvider;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;

public class MuleValueProviderService
implements ValueProviderService {
    @Inject
    private ConfigurationComponentLocator componentLocator;

    public ValueResult getValues(Location location, String providerName) {
        return this.getValueResult(() -> this.findValueProvider(location, providerName, null).resolve());
    }

    public ValueResult getFieldValues(Location location, String parameterName, String targetSelector) {
        return this.getValueResult(() -> this.findValueProvider(location, parameterName, targetSelector).resolve());
    }

    private ValueResult getValueResult(ValueResultSupplier valueSupplier) {
        ValueResult result;
        try {
            result = ValueResult.resultFrom(valueSupplier.get());
        }
        catch (ValueResolvingException e) {
            ResolvingFailure failure = ResolvingFailure.Builder.newFailure((Throwable)e).withFailureCode(e.getFailureCode()).build();
            result = ValueResult.resultFrom((ResolvingFailure)failure);
        }
        catch (Exception e) {
            result = ValueResult.resultFrom((ResolvingFailure)ResolvingFailure.Builder.newFailure((Throwable)e).build());
        }
        return result;
    }

    private ValueProvider findValueProvider(Location location, String parameterName, String targetSelector) throws ValueResolvingException {
        boolean isConnection = LocationUtils.isConnection(location);
        Location realLocation = isConnection ? LocationUtils.deleteLastPartFromLocation(location) : location;
        Object component = this.findComponent(realLocation);
        if (component instanceof ComponentValueProvider) {
            if (targetSelector != null) {
                return () -> ((ComponentValueProvider)component).getValues(parameterName, targetSelector);
            }
            return () -> ((ComponentValueProvider)component).getValues(parameterName);
        }
        if (component instanceof ConfigurationParameterValueProvider) {
            if (isConnection) {
                if (targetSelector != null) {
                    return () -> ((ConfigurationParameterValueProvider)component).getConnectionValues(parameterName, targetSelector);
                }
                return () -> ((ConfigurationParameterValueProvider)component).getConnectionValues(parameterName);
            }
            if (targetSelector != null) {
                return () -> ((ConfigurationParameterValueProvider)component).getConfigValues(parameterName, targetSelector);
            }
            return () -> ((ConfigurationParameterValueProvider)component).getConfigValues(parameterName);
        }
        throw new ValueResolvingException(String.format("The found element in the Location [%s] is not capable of provide Values", location), "NOT_VALUE_PROVIDER_ENABLED");
    }

    private Object findComponent(Location location) throws ValueResolvingException {
        return this.componentLocator.find(location).orElseThrow(() -> new ValueResolvingException(String.format("Invalid location [%s]. No element found in the given location.", location), "INVALID_LOCATION"));
    }

    @FunctionalInterface
    private static interface ValueResultSupplier {
        public Set<Value> get() throws Exception;
    }
}

