/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.queue;

import java.io.Serializable;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.util.queue.Queue;
import org.mule.runtime.core.internal.store.DeserializationPostInitialisable;
import org.mule.runtime.core.internal.util.queue.QueueStore;
import org.mule.runtime.core.internal.util.queue.TransactionContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionAwareQueueStore
implements Queue {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionAwareQueueStore.class);
    private final MuleContext muleContext;
    private final TransactionContextProvider transactionContextProvider;
    private final QueueStore queue;

    public TransactionAwareQueueStore(QueueStore queue, TransactionContextProvider transactionContextProvider, MuleContext muleContext) {
        this.queue = queue;
        this.transactionContextProvider = transactionContextProvider;
        this.muleContext = muleContext;
    }

    @Override
    public void put(Serializable item) throws InterruptedException {
        this.offer(item, Long.MAX_VALUE);
    }

    @Override
    public void clear() throws InterruptedException {
        if (this.transactionContextProvider.isTransactional()) {
            this.transactionContextProvider.getTransactionalContext().clear(this.queue);
        } else {
            this.queue.clear();
        }
    }

    @Override
    public boolean offer(Serializable item, long timeout) throws InterruptedException {
        if (this.transactionContextProvider.isTransactional()) {
            return this.transactionContextProvider.getTransactionalContext().offer(this.queue, item, timeout);
        }
        return this.queue.offer(item, 0, timeout);
    }

    @Override
    public Serializable take() throws InterruptedException {
        return this.poll(Long.MAX_VALUE);
    }

    @Override
    public void untake(Serializable item) throws InterruptedException {
        if (this.transactionContextProvider.isTransactional()) {
            this.transactionContextProvider.getTransactionalContext().untake(this.queue, item);
        } else {
            this.queue.untake(item);
        }
    }

    @Override
    public Serializable poll(long timeout) throws InterruptedException {
        try {
            if (this.transactionContextProvider.isTransactional()) {
                Serializable item = this.transactionContextProvider.getTransactionalContext().poll(this.queue, timeout);
                return this.postProcessIfNeeded(item);
            }
            return this.postProcessIfNeeded(this.queue.poll(timeout));
        }
        catch (InterruptedException iex) {
            if (!this.muleContext.isStopping()) {
                throw iex;
            }
            return null;
        }
    }

    @Override
    public Serializable peek() throws InterruptedException {
        if (this.transactionContextProvider.isTransactional()) {
            Serializable item = this.transactionContextProvider.getTransactionalContext().peek(this.queue);
            return this.postProcessIfNeeded(item);
        }
        return this.postProcessIfNeeded(this.queue.peek());
    }

    @Override
    public void dispose() throws MuleException, InterruptedException {
        this.queue.dispose();
    }

    @Override
    public int size() {
        if (this.transactionContextProvider.isTransactional()) {
            return this.transactionContextProvider.getTransactionalContext().size(this.queue);
        }
        return this.queue.getSize();
    }

    public String getName() {
        return this.queue.getName();
    }

    private Serializable postProcessIfNeeded(Serializable item) {
        try {
            if (item instanceof DeserializationPostInitialisable) {
                DeserializationPostInitialisable.Implementation.init(item, this.muleContext);
            }
            return item;
        }
        catch (Exception e) {
            LOGGER.warn("Unable to deserialize message", (Throwable)e);
            return null;
        }
    }
}

