/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.journal.queue;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import javax.transaction.xa.Xid;
import org.mule.runtime.api.serialization.SerializationProtocol;
import org.mule.runtime.core.internal.util.journal.JournalEntrySerializer;
import org.mule.runtime.core.internal.util.journal.queue.AbstractQueueTransactionJournal;
import org.mule.runtime.core.internal.util.journal.queue.AbstractQueueTxJournalEntry;
import org.mule.runtime.core.internal.util.journal.queue.MuleXid;
import org.mule.runtime.core.internal.util.journal.queue.XaQueueTxJournalEntry;

public class XaTxQueueTransactionJournal
extends AbstractQueueTransactionJournal<Xid, XaQueueTxJournalEntry> {
    public XaTxQueueTransactionJournal(String logFilesDirectory, final SerializationProtocol serializer, Integer maximumFileSizeInMegabytes) {
        super(logFilesDirectory, new JournalEntrySerializer<Xid, XaQueueTxJournalEntry>(){

            @Override
            public XaQueueTxJournalEntry deserialize(DataInputStream inputStream) throws IOException {
                return new XaQueueTxJournalEntry(inputStream, serializer);
            }

            @Override
            public void serialize(XaQueueTxJournalEntry journalEntry, DataOutputStream dataOutputStream) {
                journalEntry.write(dataOutputStream, serializer);
            }
        }, maximumFileSizeInMegabytes);
    }

    public XaTxQueueTransactionJournal(String logFilesDirectory, SerializationProtocol serializer) {
        this(logFilesDirectory, serializer, null);
    }

    @Override
    protected XaQueueTxJournalEntry createUpdateJournalEntry(Xid txId, byte operation, String queueName, Serializable serialize) {
        return new XaQueueTxJournalEntry(txId, operation, queueName, serialize);
    }

    @Override
    protected XaQueueTxJournalEntry createCheckpointJournalEntry(Xid txId, byte operation) {
        return new XaQueueTxJournalEntry(txId, operation);
    }

    public void logPrepare(Xid xid) {
        this.getJournal().logCheckpointOperation(this.createCheckpointJournalEntry(xid, AbstractQueueTxJournalEntry.Operation.PREPARE.getByteRepresentation()));
    }

    @Override
    public Collection<XaQueueTxJournalEntry> getLogEntriesForTx(Xid txId) {
        return super.getLogEntriesForTx(new MuleXid(txId));
    }
}

