/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.attribute;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.util.attribute.AttributeEvaluatorDelegate;

public final class ExpressionAttributeEvaluatorDelegate<T>
implements AttributeEvaluatorDelegate<T> {
    private static final Set<Class<?>> BLACK_LIST_TYPES = new HashSet<Class>(Arrays.asList(Object.class, InputStream.class, Iterator.class, Serializable.class));
    private final CompiledExpression expression;
    private final DataType expectedDataType;

    public ExpressionAttributeEvaluatorDelegate(CompiledExpression expression, DataType expectedDataType) {
        this.expression = expression;
        this.expectedDataType = expectedDataType;
    }

    @Override
    public TypedValue<T> resolve(CoreEvent event, ExtendedExpressionManager expressionManager) {
        ComponentLocation location = event.getContext().getOriginatingLocation();
        try (ExpressionManagerSession session = expressionManager.openSession(location, event, BindingContextUtils.NULL_BINDING_CONTEXT);){
            TypedValue<T> typedValue = this.resolveExpressionWithSession(session);
            return typedValue;
        }
    }

    @Override
    public TypedValue<T> resolve(ExpressionManagerSession session) {
        return this.resolveExpressionWithSession(session);
    }

    @Override
    public TypedValue<T> resolve(BindingContext context, ExtendedExpressionManager expressionManager) {
        try (ExpressionManagerSession session = expressionManager.openSession(context);){
            TypedValue<T> typedValue = this.resolveExpressionWithSession(session);
            return typedValue;
        }
    }

    private TypedValue<T> resolveExpressionWithSession(ExpressionManagerSession session) {
        if (this.hasExpectedDataType()) {
            return session.evaluate(this.expression, this.expectedDataType);
        }
        return session.evaluate(this.expression);
    }

    private boolean hasExpectedDataType() {
        return this.expectedDataType != null && !BLACK_LIST_TYPES.contains(this.expectedDataType.getType());
    }
}

