/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.simple;

import java.io.Serializable;
import java.nio.charset.Charset;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.AbstractTransformer;
import org.mule.runtime.core.api.transformer.DiscoverableTransformer;
import org.mule.runtime.core.api.transformer.TransformerException;

public class SerializableToByteArray
extends AbstractTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 2;

    public SerializableToByteArray() {
        this.registerSourceType(DataType.fromType(Serializable.class));
        this.setReturnDataType(DataType.BYTE_ARRAY);
    }

    @Override
    public Object doTransform(Object src, Charset outputEncoding) throws TransformerException {
        try {
            return this.muleContext.getObjectSerializer().getExternalProtocol().serialize(src);
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }

    @Override
    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    @Override
    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

