/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.graph;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.internal.transformer.graph.ConverterFilter;

public class TypeMatchingVertexesFilter
implements ConverterFilter {
    @Override
    public List<Converter> filter(List<Converter> converters, DataType source, DataType result) {
        List<Converter> filteredByType = this.filterByResultType(this.filterBySourceType(converters, source), result);
        if (!MediaType.ANY.matches(result.getMediaType())) {
            return this.filterByResultMimeType(filteredByType, result);
        }
        return filteredByType;
    }

    private List<Converter> filterBySourceType(List<Converter> converters, DataType source) {
        return this.filterBySource(converters, dataType -> dataType.getType().equals(source.getType()));
    }

    private List<Converter> filterByResultType(List<Converter> converters, DataType result) {
        return this.filterByResult(converters, converter -> converter.getReturnDataType().getType().equals(result.getType()));
    }

    private List<Converter> filterByResultMimeType(List<Converter> converters, DataType result) {
        return this.filterByResult(converters, converter -> converter.getReturnDataType().getMediaType().matches(result.getMediaType()));
    }

    private List<Converter> filterBySource(List<Converter> converters, Predicate<DataType> matcher) {
        List<Converter> filteredConvertersBySource = converters.stream().filter(converter -> converter.getSourceDataTypes().stream().anyMatch(matcher)).collect(Collectors.toList());
        if (filteredConvertersBySource.isEmpty()) {
            filteredConvertersBySource = converters;
        }
        return filteredConvertersBySource;
    }

    private List<Converter> filterByResult(List<Converter> converters, Predicate<Converter> matcher) {
        List<Converter> filteredConvertersByResult = converters.stream().filter(matcher).collect(Collectors.toList());
        if (filteredConvertersByResult.isEmpty()) {
            filteredConvertersByResult = converters;
        }
        return filteredConvertersByResult;
    }
}

