/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.object;

import java.util.Iterator;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.streaming.object.CursorIterator;
import org.mule.runtime.core.api.streaming.object.InMemoryCursorIteratorConfig;
import org.mule.runtime.core.internal.streaming.object.AbstractCursorIteratorProvider;
import org.mule.runtime.core.internal.streaming.object.BufferedCursorIterator;
import org.mule.runtime.core.internal.streaming.object.InMemoryObjectStreamBuffer;
import org.mule.runtime.core.internal.streaming.object.ObjectStreamBuffer;

public class InMemoryCursorIteratorProvider
extends AbstractCursorIteratorProvider {
    private final ObjectStreamBuffer buffer;

    public InMemoryCursorIteratorProvider(Iterator stream, InMemoryCursorIteratorConfig config, ComponentLocation originatingLocation, boolean trackCursorProviderClose) {
        super(stream, originatingLocation, trackCursorProviderClose);
        this.buffer = new InMemoryObjectStreamBuffer(stream, config);
        this.buffer.initialise();
    }

    public InMemoryCursorIteratorProvider(Iterator stream, InMemoryCursorIteratorConfig config) {
        this(stream, config, null, false);
    }

    @Override
    protected CursorIterator doOpenCursor() {
        return new BufferedCursorIterator(this.buffer, this);
    }

    public void releaseResources() {
        if (this.buffer != null) {
            this.buffer.close();
        }
    }
}

