/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.core.api.construct.BackPressureReason;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Sink;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

class PerThreadSink
implements Sink,
Disposable {
    private final Supplier<Sink> sinkSupplier;
    private final Cache<Thread, Sink> sinkCache = CacheBuilder.newBuilder().weakValues().removalListener(notification -> LifecycleUtils.disposeIfNeeded(notification.getValue(), (Logger)NOPLogger.NOP_LOGGER)).build();

    public PerThreadSink(Supplier<Sink> sinkSupplier) {
        this.sinkSupplier = sinkSupplier;
    }

    @Override
    public void accept(CoreEvent event) {
        try {
            ((Sink)this.sinkCache.get((Object)Thread.currentThread(), () -> this.sinkSupplier.get())).accept(event);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Unable to create Sink for Thread " + String.valueOf(Thread.currentThread()), e.getCause());
        }
    }

    @Override
    public BackPressureReason emit(CoreEvent event) {
        try {
            return ((Sink)this.sinkCache.get((Object)Thread.currentThread(), () -> this.sinkSupplier.get())).emit(event);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Unable to create Sink for Thread " + String.valueOf(Thread.currentThread()), e.getCause());
        }
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.sinkCache.asMap().entrySet(), (Logger)NOPLogger.NOP_LOGGER);
        this.sinkCache.invalidateAll();
    }
}

