/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util.compression;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.compression.CompressionStrategy;
import org.mule.runtime.core.internal.transformer.compression.GZIPCompressorInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GZipCompression
implements CompressionStrategy {
    public static final int DEFAULT_BUFFER_SIZE = 32768;
    private static final Logger logger = LoggerFactory.getLogger(GZipCompression.class);

    @Override
    public boolean isCompressed(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length < 2) {
            return false;
        }
        return bytes[0] == 31 && bytes[1] == -117;
    }

    @Override
    public byte[] compressByteArray(byte[] bytes) throws IOException {
        byte[] byArray;
        if (bytes == null || this.isCompressed(bytes)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Data already compressed; doing nothing");
            }
            return bytes;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Compressing message of size: " + bytes.length);
        }
        ByteArrayOutputStream baos = null;
        GZIPOutputStream gzos = null;
        try {
            baos = new ByteArrayOutputStream(32768);
            gzos = new GZIPOutputStream((OutputStream)baos);
            gzos.write(bytes, 0, bytes.length);
            gzos.finish();
            gzos.close();
            byte[] compressedByteArray = baos.toByteArray();
            baos.close();
            if (logger.isDebugEnabled()) {
                logger.debug("Compressed message to size: " + compressedByteArray.length);
            }
            byArray = compressedByteArray;
        }
        catch (IOException ioex) {
            try {
                throw ioex;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(gzos);
                IOUtils.closeQuietly((Closeable)baos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(gzos);
        IOUtils.closeQuietly((Closeable)baos);
        return byArray;
    }

    @Override
    public InputStream compressInputStream(InputStream is) throws IOException {
        return new GZIPCompressorInputStream(is);
    }

    @Override
    public byte[] uncompressByteArray(byte[] bytes) throws IOException {
        byte[] byArray;
        if (!this.isCompressed(bytes)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Data already uncompressed; doing nothing");
            }
            return bytes;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Uncompressing message of size: " + bytes.length);
        }
        ByteArrayInputStream bais = null;
        GZIPInputStream gzis = null;
        ByteArrayOutputStream baos = null;
        try {
            bais = new ByteArrayInputStream(bytes);
            gzis = new GZIPInputStream(bais);
            baos = new ByteArrayOutputStream(32768);
            org.apache.commons.io.IOUtils.copy((InputStream)gzis, (OutputStream)baos);
            gzis.close();
            bais.close();
            byte[] uncompressedByteArray = baos.toByteArray();
            baos.close();
            if (logger.isDebugEnabled()) {
                logger.debug("Uncompressed message to size: " + uncompressedByteArray.length);
            }
            byArray = uncompressedByteArray;
        }
        catch (IOException ioex) {
            try {
                throw ioex;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(gzis);
                IOUtils.closeQuietly(bais);
                IOUtils.closeQuietly(baos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(gzis);
        IOUtils.closeQuietly(bais);
        IOUtils.closeQuietly((Closeable)baos);
        return byArray;
    }

    @Override
    public InputStream uncompressInputStream(InputStream is) throws IOException {
        return new GZIPInputStream(is);
    }
}

