/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.context.notification;

import java.io.Serializable;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.QName;
import org.mule.api.annotation.NoExtend;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;

@NoInstantiate
@NoExtend
public class FlowStackElement
implements Serializable {
    private static final long serialVersionUID = -2372094725681872367L;
    private final String flowName;
    private final String processorPath;
    private final transient ComponentLocation executingLocation;
    private final transient Map<QName, Object> executingComponentAnnotations;
    private final long creationTime;
    private final transient ComponentIdentifier chainIdentifier;

    public FlowStackElement(String flowName, String processorPath, ComponentLocation executingLocation, Map<QName, Object> executingComponentAnnotations) {
        this(flowName, null, processorPath, executingLocation, executingComponentAnnotations);
    }

    public FlowStackElement(String flowName, ComponentIdentifier chainIdentifier, String processorPath, ComponentLocation executingLocation, Map<QName, Object> executingComponentAnnotations) {
        this.flowName = flowName;
        this.processorPath = processorPath;
        this.executingLocation = Objects.requireNonNull(executingLocation);
        this.executingComponentAnnotations = executingComponentAnnotations;
        this.creationTime = Instant.now().toEpochMilli();
        this.chainIdentifier = chainIdentifier;
    }

    @Deprecated
    public String getProcessorPath() {
        return this.processorPath;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public ComponentIdentifier getChainIdentifier() {
        return this.chainIdentifier;
    }

    public ComponentLocation executingLocation() {
        return this.executingLocation;
    }

    public Map<QName, Object> executingComponentAnnotations() {
        return this.executingComponentAnnotations;
    }

    public String executingComponentSourceLocation() {
        return this.executingComponentAnnotations != null ? (String)this.executingComponentAnnotations.get(Component.Annotations.SOURCE_LOCATION_ANNOTATION_KEY) : null;
    }

    public long getCreationTimeLong() {
        return this.creationTime;
    }

    public long getElapsedTimeLong() {
        return Instant.now().toEpochMilli() - this.creationTime;
    }

    @Deprecated
    public Long getCreationTime() {
        return this.creationTime;
    }

    @Deprecated
    public Long getElapsedTime() {
        return System.currentTimeMillis() - this.creationTime;
    }

    public String toString() {
        if (this.processorPath == null) {
            return this.flowName;
        }
        return this.flowName.concat("(").concat(this.processorPath).concat(")");
    }

    public String toStringWithElapsedTime() {
        return this.toString().concat(" ").concat(Long.toString(this.getElapsedTimeLong())).concat(" ms");
    }

    public String toStringEventDumpFormat() {
        return this.executingLocation().getComponentIdentifier().getIdentifier().toString().concat("@").concat(this.executingLocation().getLocation()).concat("(" + this.executingComponentSourceLocation() + ")").concat(" ").concat(Long.toString(this.getElapsedTimeLong())).concat(" ms");
    }
}

