/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.config;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.FeatureContext;

public class FeatureFlaggingRegistry {
    public static final String FEATURE_CAN_NOT_BE_NULL = "Feature can not be null";
    public static final String FEATURE_ALREADY_REGISTERED = "Feature %s already registered";
    public static final String CONDITION_CAN_NOT_BE_NULL = "Error registering %s: condition can not be null";
    private final Map<Feature, Predicate<MuleContext>> configurations = new ConcurrentHashMap<Feature, Predicate<MuleContext>>();
    private final Map<Feature, Predicate<FeatureContext>> featureFlagConfigurations = new ConcurrentHashMap<Feature, Predicate<FeatureContext>>();
    private static final FeatureFlaggingRegistry INSTANCE = new FeatureFlaggingRegistry();

    public static FeatureFlaggingRegistry getInstance() {
        return INSTANCE;
    }

    private FeatureFlaggingRegistry() {
    }

    @Deprecated
    public void registerFeature(Feature feature, Predicate<MuleContext> condition) {
        this.validate(feature, condition);
        Predicate<MuleContext> added = this.configurations.putIfAbsent(feature, condition);
        if (added != null) {
            throw new IllegalArgumentException(String.format(FEATURE_ALREADY_REGISTERED, feature));
        }
    }

    public void registerFeatureFlag(Feature feature, Predicate<FeatureContext> condition) {
        this.validate(feature, condition);
        Predicate<FeatureContext> added = this.featureFlagConfigurations.putIfAbsent(feature, condition);
        if (added != null) {
            throw new IllegalArgumentException(String.format(FEATURE_ALREADY_REGISTERED, feature));
        }
    }

    private void validate(Feature feature, Predicate<?> condition) {
        if (feature == null) {
            throw new IllegalArgumentException(FEATURE_CAN_NOT_BE_NULL);
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format(CONDITION_CAN_NOT_BE_NULL, feature));
        }
    }

    @Deprecated
    public Map<Feature, Predicate<MuleContext>> getFeatureConfigurations() {
        return Collections.unmodifiableMap(this.configurations);
    }

    public Map<Feature, Predicate<FeatureContext>> getFeatureFlagConfigurations() {
        return this.featureFlagConfigurations;
    }

    protected void clearFeatureConfigurations() {
        this.configurations.clear();
        this.featureFlagConfigurations.clear();
    }
}

