/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.introspector.internal.extractor.property;

import com.mulesoft.runtime.introspector.internal.extractor.property.PropertyBuilder;
import com.mulesoft.runtime.introspector.model.Property;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.TimeType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesHierarchyBuilder;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolverProvider;
import org.mule.runtime.config.api.properties.PropertiesResolverUtils;
import org.mule.runtime.config.internal.model.dsl.ClassLoaderResourceProvider;
import org.mule.runtime.config.internal.model.dsl.config.PropertiesResolverConfigurationProperties;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.properties.api.ResourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigPropertiesDataExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigPropertiesDataExtractor.class);
    public static final String CONFIG_PROPERTIES_KEY = "config-properties";
    private static final Pattern CONFIG_PROPERTY_USAGE = Pattern.compile("(?<!\\\\)\\$\\{([^}]+)}");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Property> extractFrom(ArtifactAst artifact, ClassLoader appClassloader) {
        LinkedHashMap<String, Property> configPropertiesMap = new LinkedHashMap<String, Property>();
        Optional<ConfigurationProperties> domainConfigProperties = Optional.empty();
        try {
            domainConfigProperties = artifact.getParent().map(domainAst -> {
                ConfigurationPropertiesResolverProvider obtainDefaultValues = this.obtainDefaultValues((ArtifactAst)domainAst, Optional.empty(), appClassloader);
                this.doExtractConfigPropertiesFromArtifact((ArtifactAst)artifact.getParent().get(), configPropertiesMap, (ConfigurationProperties)obtainDefaultValues);
                return obtainDefaultValues;
            });
            this.extractConfigPropertiesFromArtifact(artifact, appClassloader, configPropertiesMap, domainConfigProperties);
        }
        finally {
            domainConfigProperties.filter(Disposable.class::isInstance).map(Disposable.class::cast).ifPresent(cp -> cp.dispose());
        }
        return configPropertiesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractConfigPropertiesFromArtifact(ArtifactAst artifact, ClassLoader appClassloader, Map<String, Property> configPropertiesMap, Optional<ConfigurationProperties> domainProperties) {
        ConfigurationPropertiesResolverProvider artifactProperties = this.obtainDefaultValues(artifact, domainProperties, appClassloader);
        try {
            this.doExtractConfigPropertiesFromArtifact(artifact, configPropertiesMap, (ConfigurationProperties)artifactProperties);
        }
        finally {
            LifecycleUtils.disposeIfNeeded((Object)artifactProperties, (Logger)LOGGER);
        }
    }

    private void doExtractConfigPropertiesFromArtifact(ArtifactAst artifact, Map<String, Property> configPropertiesMap, ConfigurationProperties artifactProperties) {
        artifact.recursiveStream().forEach(c -> this.extractConfigPropertiesFrom((ComponentAst)c, configPropertiesMap, artifactProperties));
    }

    private ConfigurationPropertiesResolverProvider obtainDefaultValues(ArtifactAst artifact, Optional<ConfigurationProperties> domainProperties, ClassLoader appClassloader) {
        ConfigurationPropertiesResolverProvider properties = this.createIsolatedConfigurationAttributeResolver(artifact, Collections.emptyMap(), domainProperties, (ResourceProvider)new ClassLoaderResourceProvider(appClassloader));
        try {
            LifecycleUtils.initialiseIfNeeded((Object)properties);
        }
        catch (InitialisationException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        return properties;
    }

    private void extractConfigPropertiesFrom(ComponentAst component, Map<String, Property> configPropertiesMap, ConfigurationProperties defaultValues) {
        component.getParameters().stream().filter(p -> p.getRawValue() != null).forEach(p -> {
            this.findPropertyUsages(p.getRawValue(), propName -> {
                Optional propertyValue;
                PropertyBuilder builder = new PropertyBuilder();
                this.populateDataType((ComponentParameterAst)p, builder);
                try {
                    propertyValue = defaultValues.resolveProperty(propName);
                }
                catch (Exception e) {
                    propertyValue = Optional.empty();
                }
                if (propertyValue.isPresent()) {
                    builder.setDefaultValue(propertyValue.get().toString());
                } else if (p.getModel().getDefaultValue() != null) {
                    builder.setDefaultValue(p.getModel().getDefaultValue().toString());
                }
                configPropertiesMap.putIfAbsent((String)propName, builder.build());
            });
            MuleAstUtils.doOnParamComponents((ComponentParameterAst)p, c -> this.extractConfigPropertiesFrom((ComponentAst)c, configPropertiesMap, defaultValues));
        });
    }

    void findPropertyUsages(String rawValue, Consumer<String> onProperty) {
        Matcher matcher = CONFIG_PROPERTY_USAGE.matcher(rawValue);
        while (matcher.find()) {
            onProperty.accept(matcher.group(1));
        }
    }

    private void populateDataType(ComponentParameterAst p, final PropertyBuilder configPropertyBuilderMap) {
        p.getModel().getType().accept(new MetadataTypeVisitor(){

            public void visitBinaryType(BinaryType binaryType) {
                configPropertyBuilderMap.setType("binary");
            }

            public void visitBoolean(BooleanType booleanType) {
                configPropertyBuilderMap.setType("boolean");
            }

            public void visitDateTime(DateTimeType dateTimeType) {
                configPropertyBuilderMap.setType("dateTime");
            }

            public void visitDate(DateType dateType) {
                configPropertyBuilderMap.setType("date");
            }

            public void visitNull(NullType nullType) {
                configPropertyBuilderMap.setType("null");
            }

            public void visitVoid(VoidType voidType) {
                configPropertyBuilderMap.setType("void");
            }

            public void visitNumber(NumberType numberType) {
                configPropertyBuilderMap.setType("number");
            }

            public void visitString(StringType stringType) {
                Optional annotation = stringType.getAnnotation(EnumAnnotation.class);
                if (annotation.isPresent()) {
                    configPropertyBuilderMap.setType("enum");
                    configPropertyBuilderMap.setValues(Arrays.stream(((EnumAnnotation)annotation.get()).getValues()).map(Object::toString).collect(Collectors.toList()));
                } else {
                    configPropertyBuilderMap.setType("string");
                }
            }

            public void visitTime(TimeType timeType) {
                configPropertyBuilderMap.setType("time");
            }

            public void visitObject(ObjectType objectType) {
                configPropertyBuilderMap.setType("object");
            }

            public void visitArrayType(ArrayType arrayType) {
                configPropertyBuilderMap.setType("array");
            }

            protected void defaultVisit(MetadataType metadataType) {
                configPropertyBuilderMap.setType("other");
            }
        });
    }

    private ConfigurationPropertiesResolverProvider createIsolatedConfigurationAttributeResolver(ArtifactAst artifactAst, Map<String, String> deploymentProperties, Optional<ConfigurationProperties> domainProperties, ResourceProvider externalResourceProvider) {
        Supplier globalPropertiesSupplier = PropertiesResolverUtils.createGlobalPropertiesSupplier((ArtifactAst)artifactAst);
        ConfigurationPropertiesResolver partialResolver = new ConfigurationPropertiesHierarchyBuilder().withDeploymentProperties(deploymentProperties).withGlobalPropertiesSupplier(globalPropertiesSupplier).withoutFailuresIfPropertyNotPresent().build();
        artifactAst.updatePropertiesResolver((UnaryOperator)partialResolver);
        ConfigurationPropertiesHierarchyBuilder completeBuilder = new ConfigurationPropertiesHierarchyBuilder().withDeploymentProperties(deploymentProperties).withPropertiesFile(externalResourceProvider).withGlobalPropertiesSupplier(globalPropertiesSupplier);
        domainProperties.ifPresent(arg_0 -> ((ConfigurationPropertiesHierarchyBuilder)completeBuilder).withDomainPropertiesResolver(arg_0));
        PropertiesResolverUtils.getConfigurationPropertiesProvidersFromComponents((ArtifactAst)artifactAst, (ResourceProvider)externalResourceProvider, (ConfigurationPropertiesResolver)partialResolver, (boolean)true).forEach(provider -> {
            try {
                LifecycleUtils.initialiseIfNeeded((Object)provider);
                completeBuilder.withApplicationProperties(provider);
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage());
            }
        });
        return new PropertiesResolverConfigurationProperties(completeBuilder.build());
    }
}

