/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.introspector.internal.extractor.java;

import com.google.common.collect.Streams;
import com.mulesoft.runtime.introspector.exception.IntrospectionException;
import com.mulesoft.runtime.introspector.internal.extractor.file.ArtifactPathWalker;
import com.mulesoft.runtime.introspector.internal.extractor.file.ArtifactPathWalkerConfigurer;
import com.mulesoft.runtime.introspector.internal.extractor.file.ArtifactPathWalkerVisitor;
import com.mulesoft.runtime.introspector.model.java.JavaComponentsResult;
import com.mulesoft.runtime.introspector.model.java.JavaLibrary;
import com.mulesoft.runtime.introspector.model.java.MulePlugin;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaComponentsDataExtractor
implements ArtifactPathWalkerConfigurer<Set<String>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaComponentsDataExtractor.class);
    public static final String JAVA_COMPONENTS = "javaComponents";

    public JavaComponentsResult extractFrom(ArtifactAst artifact, ClassLoader artifactClassloader, Optional<DeployableProjectModel> deployableProjectModel, ArtifactPathWalker artifactPathWalker) throws IntrospectionException {
        Boolean hasJavaClasses;
        Map<String, MulePlugin> mulePlugins = this.introspectMulePlugins(artifact);
        List<JavaLibrary> javaLibraries = this.introspectJavaLibraries(deployableProjectModel);
        try {
            hasJavaClasses = this.hasJavaClasses((Set)artifactPathWalker.getResultFor(this).get());
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new IntrospectionException(e);
        }
        catch (ExecutionException e) {
            throw new IntrospectionException(e.getCause());
        }
        return new JavaComponentsResult(mulePlugins, javaLibraries, hasJavaClasses, Collections.emptyList());
    }

    private Map<String, MulePlugin> introspectMulePlugins(ArtifactAst artifact) {
        return artifact.dependencies().stream().filter(ext -> ext.getArtifactCoordinates().isPresent()).map(ext -> new MulePlugin(ext.getName(), ((ArtifactCoordinates)ext.getArtifactCoordinates().get()).getGroupId(), ((ArtifactCoordinates)ext.getArtifactCoordinates().get()).getArtifactId(), ((ArtifactCoordinates)ext.getArtifactCoordinates().get()).getVersion(), this.sortedJavaVersions(ext.getName(), ext.getSupportedJavaVersions()))).collect(Collectors.toMap(mp -> mp.getName(), UnaryOperator.identity()));
    }

    private List<String> sortedJavaVersions(String extensionName, Set<String> javaVersions) {
        try {
            TreeSet<String> sorted = new TreeSet<String>((v1, v2) -> {
                String[] v1Parts = v1.split("\\.");
                String[] v2Parts = v2.split("\\.");
                int majorCompare = Integer.parseInt(v1Parts[0]) - Integer.parseInt(v2Parts[0]);
                if (majorCompare != 0) {
                    return majorCompare;
                }
                int v1Minor = v1Parts.length > 1 ? Integer.parseInt(v1Parts[1]) : 0;
                int v2Minor = v2Parts.length > 1 ? Integer.parseInt(v2Parts[1]) : 0;
                return v1Minor - v2Minor;
            });
            sorted.addAll(javaVersions);
            return new ArrayList<String>(sorted);
        }
        catch (NumberFormatException nfe) {
            LOGGER.warn("Cannot parse javaVersions: " + javaVersions + " declared in extension `" + extensionName + "`", (Throwable)nfe);
            return new ArrayList<String>(javaVersions);
        }
    }

    private List<JavaLibrary> introspectJavaLibraries(Optional<DeployableProjectModel> deployableProjectModel) {
        return deployableProjectModel.map(dpm -> {
            ArrayList javaLibraries = new ArrayList();
            Streams.concat((Stream[])new Stream[]{dpm.getAdditionalPluginDependencies().values().stream().flatMap(Collection::stream), dpm.getDependencies().stream()}).filter(dep -> !"mule-plugin".equals(dep.getDescriptor().getClassifier().orElse(null))).map(dep -> new JavaLibrary(dep.getDescriptor().getGroupId(), dep.getDescriptor().getArtifactId(), dep.getDescriptor().getVersion())).forEach(javaLibraries::add);
            return javaLibraries;
        }).orElse(null);
    }

    private Boolean hasJavaClasses(Set<String> result) throws IntrospectionException {
        LOGGER.debug("Found java classes: " + result);
        if (result == null) {
            return null;
        }
        return !result.isEmpty();
    }

    @Override
    public ArtifactPathWalkerVisitor<Set<String>> getWalkerVisitor() {
        return new JavaClassesWalkerVisitor();
    }

    private static final class JavaClassesWalkerVisitor
    implements ArtifactPathWalkerVisitor<Set<String>> {
        private final Set<String> javaClasses = new TreeSet<String>();

        private JavaClassesWalkerVisitor() {
        }

        @Override
        public boolean isPathHandled(Path path) {
            return path.toString().endsWith(".class");
        }

        @Override
        public boolean isZipEntryHandled(ZipEntry entry) {
            return entry.getName().endsWith(".class");
        }

        @Override
        public void onHandledPath(String resourceName, Path path) {
            this.javaClasses.add(resourceName);
        }

        @Override
        public void onHandledZipEntry(String resourceName, ZipFile zipFile, ZipEntry entry) {
            this.javaClasses.add(resourceName);
        }

        @Override
        public Set<String> getResult() {
            return this.javaClasses;
        }
    }
}

