/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.introspector.internal.extractor.file;

import com.mulesoft.runtime.introspector.internal.extractor.file.ArtifactPathWalker;
import com.mulesoft.runtime.introspector.internal.extractor.file.ArtifactPathWalkerConfigurer;
import com.mulesoft.runtime.introspector.internal.extractor.file.ArtifactPathWalkerVisitor;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public abstract class AbstractArtifactPathWalker
implements ArtifactPathWalker {
    private final Executor executor;
    private final Path artifactPath;
    private final Map<Object, ArtifactPathWalkerVisitor> visitors = new HashMap<Object, ArtifactPathWalkerVisitor>();
    private final CompletableFuture<Void> walkFinished = new CompletableFuture();

    public AbstractArtifactPathWalker(Executor executor, Path artifactPath) {
        this.executor = executor;
        this.artifactPath = artifactPath;
    }

    @Override
    public void registerVisitor(ArtifactPathWalkerConfigurer extractor) {
        ArtifactPathWalkerVisitor walkerVisitor = extractor.getWalkerVisitor();
        this.visitors.put(extractor, walkerVisitor);
    }

    protected Path getArtifactPath() {
        return this.artifactPath;
    }

    protected Collection<ArtifactPathWalkerVisitor> getVisitors() {
        return this.visitors.values();
    }

    @Override
    public synchronized void walk() {
        if (this.visitors.isEmpty()) {
            this.walkFinished.complete(null);
            return;
        }
        this.executor.execute(() -> {
            try {
                this.doWalk();
                this.walkFinished.complete(null);
            }
            catch (IOException e) {
                this.walkFinished.completeExceptionally(e);
            }
        });
    }

    protected abstract void doWalk() throws IOException;

    @Override
    public synchronized <T> CompletableFuture<T> getResultFor(Object extractor) {
        return this.walkFinished.thenApply(v -> this.visitors.get(extractor).getResult());
    }
}

