/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.introspector;

import com.mulesoft.runtime.introspector.IntrospectionRequest;
import com.mulesoft.runtime.introspector.IntrospectionResult;
import com.mulesoft.runtime.introspector.IntrospectionResults;
import com.mulesoft.runtime.introspector.exception.IntrospectionException;
import com.mulesoft.runtime.introspector.internal.extractor.MuleArtifactDataExtractor;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.mule.framework.api.MuleFramework;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;

public class MuleArtifactIntrospector {
    final Set<IntrospectionResults> INTROSPECTIONS_REQUIRING_AST = new HashSet<IntrospectionResults>(Arrays.asList(IntrospectionResults.FLOWS, IntrospectionResults.SCHEDULERS, IntrospectionResults.CONFIG_PROPERTIES, IntrospectionResults.JAVA_COMPONENTS));
    private final MuleArtifactDataExtractor muleArtifactAngDataExtractor = new MuleArtifactDataExtractor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntrospectionResult introspectAppAst(IntrospectionRequest request) throws IntrospectionException {
        Executor executor = request.getExecutor().orElse(Runnable::run);
        CompletableFuture<ArtifactAst> artifactFuture = new CompletableFuture<ArtifactAst>();
        CompletableFuture<ClassLoader> artifactClassLoaderFuture = new CompletableFuture<ClassLoader>();
        CompletableFuture<Optional<DeployableProjectModel>> deployableProjectModelFuture = new CompletableFuture<Optional<DeployableProjectModel>>();
        CountDownLatch introspectionCompleteLatch = new CountDownLatch(1);
        try {
            if (request.getArtifactAst() == null && this.isArtifactAstRequired(request)) {
                executor.execute(() -> this.withMuleFramework(request.getArtifactPath(), muleFramework -> {
                    artifactFuture.complete((ArtifactAst)muleFramework.getArtifactAst().get());
                    artifactClassLoaderFuture.complete(Thread.currentThread().getContextClassLoader());
                    deployableProjectModelFuture.complete(muleFramework.getDeployableProjectModel());
                    if (request.getExecutor().isPresent()) {
                        try {
                            introspectionCompleteLatch.await();
                        }
                        catch (InterruptedException e) {
                            Thread.interrupted();
                            throw new RuntimeException(e);
                        }
                    }
                }));
            } else {
                artifactFuture.complete(request.getArtifactAst());
                artifactClassLoaderFuture.complete(request.getAppClassloader());
                deployableProjectModelFuture.complete(Optional.ofNullable(request.getDeployableProjectModel()));
            }
            IntrospectionResult introspectionResult = this.muleArtifactAngDataExtractor.extractFrom(artifactFuture, artifactClassLoaderFuture, deployableProjectModelFuture, Optional.ofNullable(request.getArtifactPath()), request.getWantedResults(), executor);
            return introspectionResult;
        }
        finally {
            introspectionCompleteLatch.countDown();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isArtifactAstRequired(IntrospectionRequest request) {
        Set<IntrospectionResults> wantedResults = request.getWantedResults();
        if (wantedResults.isEmpty()) return true;
        if (!this.INTROSPECTIONS_REQUIRING_AST.stream().anyMatch(wantedResults::contains)) return false;
        return true;
    }

    private void withMuleFramework(Path artifactPath, Consumer<MuleFramework> action) {
        try (MuleFramework muleFramework = MuleFramework.builder().fromPackagedApplication(artifactPath).usageMode(MuleFramework.UsageMode.ARTIFACT_AST).build();){
            muleFramework.onExecutionClassLoader(() -> action.accept(muleFramework));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

