/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.plugin.processor.deployment;

import com.mulesoft.mule.runtime.module.plugin.api.deployment.DeploymentListenerProvider;
import com.mulesoft.mule.runtime.plugin.ManagedMulePlugin;
import com.mulesoft.mule.runtime.plugin.processor.AbstractPluginProcessor;
import com.mulesoft.mule.runtime.plugin.processor.deployment.ClassLoaderWrapperFactory;
import com.mulesoft.mule.runtime.plugin.processor.deployment.DefaultClassLoaderWrapperFactory;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentListenerManager;

public class DeploymentListenerProviderProcessor
extends AbstractPluginProcessor {
    private final DeploymentListenerManager deploymentListenerManager;
    private final Map<String, DeploymentListener> listeners = new HashMap<String, DeploymentListener>();
    private ClassLoaderWrapperFactory<DeploymentListener> classLoaderWrapperFactory;

    public void setClassLoaderWrapperFactory(ClassLoaderWrapperFactory<DeploymentListener> classLoaderWrapperFactory) {
        this.classLoaderWrapperFactory = classLoaderWrapperFactory;
    }

    public DeploymentListenerProviderProcessor(DeploymentListenerManager deploymentListenerManager) {
        this.deploymentListenerManager = deploymentListenerManager;
        this.classLoaderWrapperFactory = new DefaultClassLoaderWrapperFactory<DeploymentListener>(DeploymentListener.class);
    }

    @Override
    protected void doStartPlugin(ManagedMulePlugin managedPlugin) {
        DeploymentListenerProvider provider = (DeploymentListenerProvider)((Object)managedPlugin.getPlugin());
        DeploymentListener deploymentListener = provider.getDeploymentListener();
        DeploymentListener proxy = this.classLoaderWrapperFactory.create(deploymentListener, deploymentListener.getClass().getClassLoader());
        this.listeners.put(managedPlugin.getName(), proxy);
        this.deploymentListenerManager.addDeploymentListener(proxy);
    }

    @Override
    protected void doStopPlugin(ManagedMulePlugin managedPlugin) {
        DeploymentListener listener = this.listeners.remove(managedPlugin.getName());
        this.deploymentListenerManager.removeDeploymentListener(listener);
    }

    @Override
    protected void doDisposePlugin(ManagedMulePlugin managedPlugin) {
    }

    @Override
    protected void doInitializePlugin(ManagedMulePlugin managedPlugin) {
    }

    @Override
    protected boolean accepts(ManagedMulePlugin managedPlugin) {
        return managedPlugin.getPlugin() instanceof DeploymentListenerProvider;
    }
}

