/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.dto.factory;

import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.nested.NestedComponentModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.MetadataTypeAdapter;
import org.mule.runtime.ast.internal.serialization.dto.ComponentAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentAstDTOModelType;
import org.mule.runtime.ast.internal.serialization.dto.ComponentParameterAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.factory.AstDTOFactoryProvider;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;

public class ComponentAstDTOFactory {
    private final AstDTOFactoryProvider astDTOFactoryProvider;

    public ComponentAstDTOFactory(AstDTOFactoryProvider astDTOFactoryProvider) {
        this.astDTOFactoryProvider = astDTOFactoryProvider;
    }

    public ComponentAstDTO from(ComponentAst componentAst) {
        return new ComponentAstDTO(Collections.unmodifiableList(componentAst.directChildrenStream().map(child -> this.astDTOFactoryProvider.getComponentAstDTOFactory().from((ComponentAst)child)).collect(Collectors.toList())), componentAst.getComponentType().toString(), componentAst.getIdentifier(), componentAst.getLocation(), componentAst.getMetadata() != null ? this.astDTOFactoryProvider.getComponentMetadataAstDTOFactory().from(componentAst.getMetadata()) : null, componentAst.getParameters().stream().map(param -> (ComponentParameterAstDTO)this.astDTOFactoryProvider.getComponentParameterAstDTOFactory().from(param)).collect(Collectors.toList()), componentAst.getComponentId().orElse(null), componentAst.getExtensionModel() != null ? this.astDTOFactoryProvider.getExtensionModelDTOFactory().from(componentAst.getExtensionModel()) : null, this.getModelName(componentAst), this.getModelType(componentAst), componentAst.getAnnotations() != null ? Collections.unmodifiableMap(componentAst.getAnnotations()) : null);
    }

    private String getModelName(ComponentAst componentAst) {
        return componentAst.getModel(MetadataTypeAdapter.class).flatMap(mt -> MetadataTypeUtils.getTypeId((MetadataType)mt.getType())).orElseGet(() -> componentAst.getModel(NamedObject.class).map(x -> {
            try {
                return x.getName();
            }
            catch (Exception e) {
                return componentAst.getIdentifier().getName();
            }
        }).orElse(null));
    }

    private ComponentAstDTOModelType getModelType(ComponentAst componentAst) {
        Optional metadataTypeAdapter = componentAst.getModel(MetadataTypeAdapter.class);
        if (metadataTypeAdapter.isPresent()) {
            if (ExtensionMetadataTypeUtils.isInfrastructure((MetadataType)((MetadataTypeAdapter)metadataTypeAdapter.get()).getType())) {
                return ComponentAstDTOModelType.INFRASTRUCTURE;
            }
            return ComponentAstDTOModelType.TYPE;
        }
        if (componentAst.getModel(ConfigurationModel.class).isPresent()) {
            return ComponentAstDTOModelType.CONFIGURATION;
        }
        if (componentAst.getModel(ConnectionProviderModel.class).isPresent()) {
            return ComponentAstDTOModelType.CONNECTION_PROVIDER;
        }
        if (componentAst.getModel(OperationModel.class).isPresent()) {
            return ComponentAstDTOModelType.OPERATION;
        }
        if (componentAst.getModel(SourceModel.class).isPresent()) {
            return ComponentAstDTOModelType.SOURCE;
        }
        if (componentAst.getModel(ConstructModel.class).isPresent()) {
            return ComponentAstDTOModelType.CONSTRUCT;
        }
        if (componentAst.getModel(NestableElementModel.class).isPresent() || componentAst.getModel(NestedComponentModel.class).isPresent()) {
            return ComponentAstDTOModelType.NESTED_COMPONENT;
        }
        if (componentAst.getModel(NestedRouteModel.class).isPresent()) {
            return ComponentAstDTOModelType.NESTED_ROUTE;
        }
        return null;
    }
}

