/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.ang.classpath;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.jpms.api.MuleContainerModule;
import org.mule.runtime.module.artifact.api.classloader.ExportedService;

public class MuleModuleDeserializer
implements JsonDeserializer<MuleContainerModule> {
    public MuleContainerModule deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        String name = jsonObject.get("name").getAsString();
        Set<String> exportedPackages = this.jsonArrayToSet(jsonObject.getAsJsonArray("exportedPackages"));
        Set<String> exportedPaths = this.jsonArrayToSet(jsonObject.getAsJsonArray("exportedPaths"));
        Set<String> privilegedExportedPackages = this.jsonArrayToSet(jsonObject.getAsJsonArray("privilegedExportedPackages"));
        Set<String> privilegedArtifacts = this.jsonArrayToSet(jsonObject.getAsJsonArray("privilegedArtifacts"));
        ArrayList exportedServices = new ArrayList();
        JsonArray exportedServicesArray = jsonObject.getAsJsonArray("exportedServices");
        exportedServicesArray.forEach(exportedService -> {
            JsonObject exportedServiceObject = exportedService.getAsJsonObject();
            String serviceInterface = exportedServiceObject.get("serviceInterface").getAsString();
            String resource = exportedServiceObject.get("resource").getAsString();
            try {
                exportedServices.add(new ExportedService(serviceInterface, new URL(resource)));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Unable to create service resource URL", e);
            }
        });
        return new MuleModule(name, exportedPackages, exportedPaths, privilegedExportedPackages, privilegedArtifacts, exportedServices);
    }

    private Set<String> jsonArrayToSet(JsonArray jsonArray) {
        HashSet<String> exportedPackages = new HashSet<String>();
        jsonArray.forEach(exportedPackage -> exportedPackages.add(exportedPackage.getAsString()));
        return exportedPackages;
    }
}

