/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.domain;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.service.ServiceRepository;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.value.ValueProviderService;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.context.notification.MuleContextListener;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.util.splash.SplashScreen;
import org.mule.runtime.deployment.model.api.DeploymentInitException;
import org.mule.runtime.deployment.model.api.DeploymentStartException;
import org.mule.runtime.deployment.model.api.InstallException;
import org.mule.runtime.deployment.model.api.artifact.ArtifactConfigurationProcessor;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelLoaderRepository;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;
import org.mule.runtime.module.deployment.impl.internal.artifact.AbstractDeployableArtifact;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactContextBuilder;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainStartedSplashScreen;
import org.mule.runtime.module.deployment.impl.internal.util.DeploymentPropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMuleDomain
extends AbstractDeployableArtifact<DomainDescriptor>
implements Domain {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMuleDomain.class);
    private static final Logger SPLASH_LOGGER = LoggerFactory.getLogger((String)"org.mule.runtime.core.internal.logging");
    private final DomainDescriptor descriptor;
    private final ServiceRepository serviceRepository;
    private final List<ArtifactPlugin> artifactPlugins;
    private final ExtensionModelLoaderRepository extensionModelLoaderRepository;
    private final ClassLoaderRepository classLoaderRepository;
    private final LockFactory runtimeLockFactory;
    private final MemoryManagementService memoryManagementService;
    private final ArtifactConfigurationProcessor artifactConfigurationProcessor;
    private MuleContextListener muleContextListener;

    public DefaultMuleDomain(DomainDescriptor descriptor, ArtifactClassLoader deploymentClassLoader, ClassLoaderRepository classLoaderRepository, ServiceRepository serviceRepository, List<ArtifactPlugin> artifactPlugins, ExtensionModelLoaderRepository extensionModelLoaderRepository, LockFactory runtimeLockFactory, MemoryManagementService memoryManagementService, ArtifactConfigurationProcessor artifactConfigurationProcessor) {
        super("domain", "domain", deploymentClassLoader);
        this.classLoaderRepository = classLoaderRepository;
        this.descriptor = descriptor;
        this.serviceRepository = serviceRepository;
        this.artifactPlugins = artifactPlugins;
        this.extensionModelLoaderRepository = extensionModelLoaderRepository;
        this.runtimeLockFactory = runtimeLockFactory;
        this.memoryManagementService = memoryManagementService;
        this.artifactConfigurationProcessor = artifactConfigurationProcessor;
    }

    public void setMuleContextListener(MuleContextListener muleContextListener) {
        Preconditions.checkArgument((muleContextListener != null ? 1 : 0) != 0, (String)"muleContextListener cannot be null");
        this.muleContextListener = muleContextListener;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public Registry getRegistry() {
        return this.artifactContext != null ? this.artifactContext.getRegistry() : null;
    }

    public File getLocation() {
        return this.descriptor.getArtifactLocation();
    }

    public ConnectivityTestingService getConnectivityTestingService() {
        return (ConnectivityTestingService)this.artifactContext.getRegistry().lookupByName("_muleConnectivityTestingService").get();
    }

    public MetadataService getMetadataService() {
        return (MetadataService)this.artifactContext.getRegistry().lookupByName("_muleMetadataService").get();
    }

    public ValueProviderService getValueProviderService() {
        return (ValueProviderService)this.artifactContext.getRegistry().lookupByName("_muleValueProviderService").get();
    }

    public List<ArtifactPlugin> getArtifactPlugins() {
        return this.artifactPlugins;
    }

    public void install() {
        ClassUtils.withContextClassLoader(null, () -> {
            if (SPLASH_LOGGER.isInfoEnabled()) {
                SPLASH_LOGGER.info(SplashScreen.miniSplash((String)String.format("New domain '%s'", this.getArtifactName())));
            }
        });
        for (String configFile : this.descriptor.getConfigResources()) {
            URL configFileUrl = this.getArtifactClassLoader().getClassLoader().getResource(configFile);
            if (configFileUrl != null) continue;
            String message = String.format("Config for domain '%s' not found: %s", this.getArtifactName(), configFile);
            throw new InstallException(I18nMessageFactory.createStaticMessage((String)message));
        }
    }

    public void init() {
        this.doInit(false, false, false);
    }

    public void initTooling() {
        this.doInit(false, false, true);
    }

    public void lazyInit() {
        this.doInit(true, true, false);
    }

    public void lazyInit(boolean disableXmlValidations) {
        this.doInit(true, disableXmlValidations, false);
    }

    public void lazyInitTooling(boolean disableXmlValidations) {
        this.doInit(true, disableXmlValidations, true);
    }

    public void doInit(boolean lazy, boolean disableXmlValidations, boolean addToolingObjectsToRegistry) throws DeploymentInitException {
        ClassUtils.withContextClassLoader(null, () -> {
            if (SPLASH_LOGGER.isInfoEnabled()) {
                SPLASH_LOGGER.info(SplashScreen.miniSplash((String)String.format("Initializing domain '%s'", this.getArtifactName())));
            }
        });
        try {
            ArtifactContextBuilder artifactBuilder = this.getArtifactContextBuilder().setArtifactName(this.getArtifactName()).setDataFolderName(this.getDescriptor().getDataFolderName()).setArtifactPlugins(this.artifactPlugins).setExecutionClassloader(this.deploymentClassLoader.getClassLoader()).setArtifactInstallationDirectory(this.getArtifactInstallationDirectory()).setArtifactConfigurationProcessor(this.artifactConfigurationProcessor).setExtensionModelLoaderRepository(this.extensionModelLoaderRepository).setArtifactType(ArtifactType.DOMAIN).setEnableLazyInit(lazy).setDisableXmlValidations(disableXmlValidations).setAddToolingObjectsToRegistry(addToolingObjectsToRegistry).setClassLoaderRepository(this.classLoaderRepository).setProperties(Optional.ofNullable(DeploymentPropertiesUtils.resolveDeploymentProperties(this.descriptor.getDataFolderName(), this.descriptor.getDeploymentProperties()))).setServiceRepository(this.serviceRepository).setRuntimeLockFactory(this.runtimeLockFactory).setMemoryManagementService(this.memoryManagementService).setArtifactCoordinates((ArtifactCoordinates)this.descriptor.getBundleDescriptor());
            if (!this.descriptor.getConfigResources().isEmpty()) {
                this.validateConfigurationFileDoNotUsesCoreNamespace();
                artifactBuilder.setConfigurationFiles(this.descriptor.getConfigResources().toArray(new String[this.descriptor.getConfigResources().size()]));
            }
            if (this.muleContextListener != null) {
                artifactBuilder.setMuleContextListener(this.muleContextListener);
            }
            this.artifactContext = artifactBuilder.build();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), ExceptionUtils.getRootCause((Throwable)e));
            throw new DeploymentInitException(I18nMessageFactory.createStaticMessage((String)ExceptionUtils.getRootCauseMessage((Throwable)e)), (Throwable)e);
        }
    }

    private void validateConfigurationFileDoNotUsesCoreNamespace() throws FileNotFoundException {
        for (String configResourceFile : this.descriptor.getConfigResources()) {
            try (Scanner scanner = new Scanner(this.getArtifactClassLoader().getClassLoader().getResourceAsStream(configResourceFile));){
                while (scanner.hasNextLine()) {
                    String lineFromFile = scanner.nextLine();
                    if (!lineFromFile.contains("<mule ")) continue;
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Domain configuration file can not be created using core namespace. Use mule-domain namespace instead."));
                }
            }
        }
    }

    public void start() {
        try {
            if (this.artifactContext != null) {
                try {
                    this.artifactContext.getMuleContext().start();
                }
                catch (MuleException e) {
                    LOGGER.error(null, ExceptionUtils.getRootCause((Throwable)e));
                    throw new DeploymentStartException(I18nMessageFactory.createStaticMessage((String)ExceptionUtils.getRootCauseMessage((Throwable)e)), (Throwable)e);
                }
            }
            this.persistArtifactState("start");
            ClassUtils.withContextClassLoader(null, () -> {
                DomainStartedSplashScreen splashScreen = new DomainStartedSplashScreen();
                splashScreen.createMessage(this.descriptor);
                SPLASH_LOGGER.info(splashScreen.toString());
            });
        }
        catch (Exception e) {
            throw new DeploymentStartException(I18nMessageFactory.createStaticMessage((String)("Failure trying to start domain " + this.getArtifactName())), (Throwable)e);
        }
    }

    public String getArtifactName() {
        return this.descriptor.getName();
    }

    public String getArtifactId() {
        return this.deploymentClassLoader.getArtifactId();
    }

    public DomainDescriptor getDescriptor() {
        return this.descriptor;
    }

    public File[] getResourceFiles() {
        return this.descriptor.getConfigResources().stream().map(configFile -> new File(this.getLocation(), (String)configFile)).collect(Collectors.toList()).toArray(new File[this.descriptor.getConfigResources().size()]);
    }

    public ArtifactClassLoader getArtifactClassLoader() {
        return this.deploymentClassLoader;
    }

    public boolean containsSharedResources() {
        return this.artifactContext != null;
    }

    protected ArtifactContextBuilder getArtifactContextBuilder() {
        return ArtifactContextBuilder.newBuilder();
    }

    protected File getArtifactInstallationDirectory() {
        return this.descriptor.getArtifactLocation();
    }
}

