/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.licm;

import com.mulesoft.licm.feature.DefaultFeatureSet;
import com.mulesoft.licm.feature.Feature;
import com.mulesoft.licm.feature.FeatureSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitlementsConfigReader {
    private static final Logger logger = LoggerFactory.getLogger(EntitlementsConfigReader.class);
    private static final String ENTITLEMENTS_PROPERTIES_FILE = "entitlements.xml";
    private static final String ENTITLEMENTS_ROOT = "entitlement";
    private static FeatureSet featureSet = new DefaultFeatureSet();

    public static void read(String entitlementKey) {
        System.setProperty("java.util.prefs.PreferencesFactory", "com.mulesoft.licm.pref.MulePreferencesFactory");
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(ENTITLEMENTS_PROPERTIES_FILE);
            try {
                Preferences.importPreferences(is);
                is.close();
            }
            catch (IOException e) {
                logger.error("entitlements.xml not found. Entitlements disabled.");
                return;
            }
            Preferences entitlement = Preferences.userRoot().node(ENTITLEMENTS_ROOT).node(entitlementKey);
            int i = 0;
            while (true) {
                String value;
                if (i == 0 && featureSet.hasFeatures()) {
                    featureSet.clearFeatures();
                }
                if ((value = entitlement.get(ENTITLEMENTS_ROOT + i, "none")).compareToIgnoreCase("none") != 0) {
                    featureSet.addFeature(new Feature(value, value));
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            logger.error("Invalid entitlements.xml", (Throwable)e);
        }
    }

    public static FeatureSet getFeatureSet() {
        return featureSet;
    }
}

