/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.internal.time.frame;

import com.mulesoft.mule.runtime.gw.api.time.DateTime;
import com.mulesoft.mule.runtime.gw.api.time.clock.Clock;
import com.mulesoft.mule.runtime.gw.api.time.frame.TimeFrame;
import com.mulesoft.mule.runtime.gw.api.time.period.Period;

public class FixedTimeFrame
implements TimeFrame {
    private static final long serialVersionUID = -2098663731137982314L;
    private final Clock clock;
    private final Period period;
    private final DateTime startTime;
    private final DateTime endTime;

    public FixedTimeFrame(Clock clock, DateTime startTime, Period period) {
        this.clock = clock;
        this.period = period;
        this.startTime = startTime;
        this.endTime = startTime.plus(period.inMillis() - 1L);
    }

    @Override
    public boolean hasFinished() {
        DateTime now = this.clock.now();
        return !this.inRange(now) && !this.isBorder(now);
    }

    private boolean isBorder(DateTime time) {
        return time.equals(this.startTime) || time.equals(this.endTime);
    }

    protected boolean inRange(DateTime time) {
        return time.isAfter(this.startTime) && time.isBefore(this.endTime);
    }

    @Override
    public long millisUntilNextTimeFrame() {
        long remainingTime = this.endTime.getMillis() - this.clock.now().getMillis();
        return remainingTime > 0L ? remainingTime : 0L;
    }

    @Override
    public long inMillis() {
        return this.period.inMillis();
    }

    @Override
    public TimeFrame next() {
        if (!this.hasFinished()) {
            return this;
        }
        return new FixedTimeFrame(this.clock, this.nextStartDate(), this.period);
    }

    @Override
    public DateTime startTime() {
        return this.startTime;
    }

    @Override
    public boolean contains(DateTime dateTime) {
        return this.inRange(dateTime) || this.isBorder(dateTime);
    }

    private DateTime nextStartDate() {
        long diffStartAndNow = this.clock.now().getMillis() - this.startTime.getMillis();
        long startOffset = Math.abs(diffStartAndNow) % this.period.inMillis();
        DateTime nextStartDate = diffStartAndNow >= 0L ? this.startTime.plus(diffStartAndNow - startOffset) : this.startTime.minus(Math.abs(diffStartAndNow) + this.period.inMillis() - startOffset);
        return nextStartDate;
    }

    public boolean equals(Object anotherObject) {
        if (anotherObject == null || !(anotherObject instanceof FixedTimeFrame)) {
            return false;
        }
        FixedTimeFrame anotherFrame = (FixedTimeFrame)anotherObject;
        return this.startTime.equals(anotherFrame.startTime) && this.endTime.equals(anotherFrame.endTime) && this.period.equals(anotherFrame.period);
    }

    public String toString() {
        return "FixedTimeFrame{ start:" + String.valueOf(this.startTime) + ", end:" + String.valueOf(this.endTime) + ", duration:" + this.period.inMillis() + ", remainingFrame:" + this.millisUntilNextTimeFrame() + "}";
    }
}

