/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.api.policy;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.http.policy.api.HttpPolicyPointcutParameters;
import org.mule.runtime.http.policy.api.SourcePolicyAwareAttributes;
import org.mule.runtime.policy.api.AttributeAwarePointcut;
import org.mule.runtime.policy.api.PolicyAwareAttributes;
import org.mule.runtime.policy.api.PolicyPointcutParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResourcePointcut
implements AttributeAwarePointcut,
Serializable {
    public static final ComponentIdentifier HTTP_REQUEST_COMPONENT_IDENTIFIER = ComponentIdentifier.builder().namespace("http").name("request").build();
    public static final ComponentIdentifier HTTP_LISTENER_COMPONENT_IDENTIFIER = ComponentIdentifier.builder().namespace("http").name("listener").build();
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpResourcePointcut.class);
    private static final long serialVersionUID = -5003310196710218800L;
    private final Pattern pathPattern;
    private final Pattern methodPattern;

    public HttpResourcePointcut(String pathRegex, String methodRegex) {
        this.pathPattern = Pattern.compile(pathRegex, 2);
        this.methodPattern = Pattern.compile(methodRegex, 2);
    }

    public boolean matches(PolicyPointcutParameters policyPointcutParameters) {
        PolicyPointcutParameters parameters = policyPointcutParameters.getSourceParameters().orElse(policyPointcutParameters);
        try {
            boolean matches;
            String path = ((HttpPolicyPointcutParameters)parameters).getPath();
            String method = ((HttpPolicyPointcutParameters)parameters).getMethod();
            boolean bl = matches = this.methodPattern.matcher(method).matches() && this.pathPattern.matcher(path).matches();
            if (!matches) {
                LOGGER.trace("Request {{}, {}} does not match the following resource pointcut: {}", new Object[]{path, method, this});
            } else {
                LOGGER.trace("Request {{}, {}} matches the following resource pointcut: {}", new Object[]{path, method, this});
            }
            return matches;
        }
        catch (ClassCastException e) {
            LOGGER.trace("Invalid parameters type found. {}", (Object)e.getMessage());
            return false;
        }
    }

    public PolicyAwareAttributes sourcePolicyAwareAttributes() {
        return new SourcePolicyAwareAttributes.Builder().requestPathPatterns(new Pattern[]{this.pathPattern}).build();
    }

    public String getPath() {
        return this.pathPattern.toString();
    }

    public String getMethod() {
        return this.methodPattern.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpResourcePointcut that = (HttpResourcePointcut)o;
        return this.pathPattern.toString().equals(that.pathPattern.toString()) && this.methodPattern.toString().equals(that.methodPattern.toString());
    }

    public int hashCode() {
        int result = this.pathPattern.toString().hashCode();
        result = 31 * result + this.methodPattern.toString().hashCode();
        return result;
    }

    public String toString() {
        return "{path=" + String.valueOf(this.pathPattern) + ", method=" + String.valueOf(this.methodPattern) + "}";
    }
}

