/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.api.client;

import com.mulesoft.mule.runtime.gw.api.construction.Builder;
import com.mulesoft.mule.runtime.gw.internal.client.ValidClient;
import java.io.Serializable;
import java.util.Objects;

public abstract class Client
implements Serializable {
    public static final String ASTERISKS = "******";
    private static final long serialVersionUID = -7969389139990798368L;

    public abstract String id();

    public abstract String secret();

    public abstract String name();

    public String toString() {
        return "Client{id='" + this.obfuscate(this.id()) + "', secret=******";
    }

    private String obfuscate(String string) {
        if (string == null) {
            return "null";
        }
        int substringLength = (int)((double)string.length() * 0.15);
        return string.substring(0, substringLength) + ASTERISKS;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Client)) {
            return false;
        }
        Client client = (Client)o;
        if (!this.id().equals(client.id())) {
            return false;
        }
        return this.secret().equals(client.secret());
    }

    public int hashCode() {
        int result = this.id().hashCode();
        result = 31 * result + this.secret().hashCode();
        return result;
    }

    public static ClientBuilder builder() {
        return new ClientBuilder();
    }

    public static class ClientBuilder
    implements Builder<Client> {
        private String id;
        private String secret;
        private String name;

        public ClientBuilder withId(String id) {
            this.id = id;
            return this;
        }

        public ClientBuilder withSecret(String secret) {
            this.secret = secret;
            return this;
        }

        public ClientBuilder withName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Client build() {
            Objects.requireNonNull(this.id, "Cannot create a Client without its ID");
            Objects.requireNonNull(this.secret, "Cannot create a Client without its Secret");
            return new ValidClient(this.id, this.secret, this.name);
        }
    }
}

