/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.cache.internal.keygenerator;

import com.mulesoft.mule.runtime.cache.api.key.MuleEventKeyGenerator;
import javax.inject.Inject;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.util.attribute.AttributeEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionMuleEventKeyGenerator
implements MuleEventKeyGenerator,
Initialisable {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private ExtendedExpressionManager expressionManager;
    private AttributeEvaluator attributeEvaluator;

    @Override
    public String generateKey(CoreEvent event) {
        Object key = this.attributeEvaluator.resolveValue(event);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Generated key for event: " + String.valueOf(event) + " key: " + String.valueOf(key));
        }
        if (key instanceof String) {
            return (String)key;
        }
        throw new IllegalStateException("Generated key must a String but was " + (key != null ? key.getClass().getName() : "null"));
    }

    public String getExpression() {
        return this.attributeEvaluator.getRawValue();
    }

    public void setExpression(String expression) {
        this.attributeEvaluator = new AttributeEvaluator(expression, DataType.STRING);
    }

    public void initialise() throws InitialisationException {
        this.attributeEvaluator.initialize(this.expressionManager);
    }
}

