/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.utils;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.construct.HasConstructModels;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.tooling.client.api.connectivity.BundleNotFoundException;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.api.extension.model.connection.ConnectionProviderModel;
import org.mule.tooling.client.api.extension.model.construct.ConstructModel;
import org.mule.tooling.client.api.extension.model.source.SourceModel;
import org.mule.tooling.client.internal.MuleRuntimeExtensionModelProvider;

public final class ExtensionModelUtils {
    private ExtensionModelUtils() {
    }

    public static DslResolvingContext createDslResolvingContext(List<ExtensionModel> muleModels, List<ExtensionModel> artifactPlugins) {
        return DslResolvingContext.getDefault((Set)ImmutableSet.builder().addAll(muleModels).addAll(artifactPlugins).build());
    }

    public static List<BundleDescriptor> toBundleDescriptors(List<ArtifactDescriptor> artifactDescriptors) {
        return artifactDescriptors.stream().map(descriptor -> new BundleDescriptor.Builder().setArtifactId(descriptor.getArtifactId()).setClassifier(descriptor.getClassifier()).setGroupId(descriptor.getGroupId()).setType(descriptor.getExtension()).setVersion(descriptor.getVersion()).build()).collect(Collectors.toList());
    }

    public static List<ExtensionModel> resolveExtensionModels(MavenClient mavenClient, MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider, List<BundleDescriptor> pluginBundleDescriptors) {
        List pluginDependencies;
        try {
            pluginDependencies = mavenClient.resolvePluginBundleDescriptorsDependencies(pluginBundleDescriptors);
        }
        catch (Exception e) {
            throw Throwables.getCausalChain((Throwable)e).stream().filter(exception -> exception.getClass().equals(ArtifactNotFoundException.class) || exception.getClass().equals(ArtifactResolutionException.class)).findFirst().map(exception -> new BundleNotFoundException(exception.getMessage(), (Exception)exception)).orElse((RuntimeException)new MuleRuntimeException((Throwable)e));
        }
        return pluginDependencies.stream().map(pluginBundleDependency -> muleRuntimeExtensionModelProvider.getExtensionModel((BundleDependency)pluginBundleDependency).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static NamedObject find(ExtensionModel extension, final org.mule.tooling.client.api.extension.model.config.ConfigurationModel config) {
        return ExtensionModelUtils.doFind(extension.getName(), config.getName(), "CONFIG", reference -> new ExtensionWalker((Reference)reference){
            final /* synthetic */ Reference val$reference;
            {
                this.val$reference = reference;
            }

            protected void onConfiguration(ConfigurationModel model) {
                if (model.getName().equals(config.getName())) {
                    this.val$reference.set((Object)model);
                    this.stop();
                }
            }
        }.walk(extension));
    }

    public static NamedObject find(ExtensionModel extension, final ConnectionProviderModel component) {
        return ExtensionModelUtils.doFind(extension.getName(), component.getName(), "CONNECTION", reference -> new ExtensionWalker((Reference)reference){
            final /* synthetic */ Reference val$reference;
            {
                this.val$reference = reference;
            }

            protected void onConnectionProvider(HasConnectionProviderModels owner, org.mule.runtime.api.meta.model.connection.ConnectionProviderModel model) {
                if (model.getName().equals(component.getName())) {
                    this.val$reference.set((Object)model);
                    this.stop();
                }
            }
        }.walk(extension));
    }

    public static NamedObject find(ExtensionModel extension, final ConstructModel construct) {
        return ExtensionModelUtils.doFind(extension.getName(), construct.getName(), "CONSTRUCT", reference -> new ExtensionWalker((Reference)reference){
            final /* synthetic */ Reference val$reference;
            {
                this.val$reference = reference;
            }

            protected void onConstruct(HasConstructModels owner, org.mule.runtime.api.meta.model.construct.ConstructModel model) {
                if (model.getName().equals(construct.getName())) {
                    this.val$reference.set((Object)model);
                    this.stop();
                }
            }
        }.walk(extension));
    }

    public static NamedObject find(ExtensionModel extension, final org.mule.tooling.client.api.extension.model.operation.OperationModel operation) {
        return ExtensionModelUtils.doFind(extension.getName(), operation.getName(), "OPERATION", reference -> new ExtensionWalker((Reference)reference){
            final /* synthetic */ Reference val$reference;
            {
                this.val$reference = reference;
            }

            protected void onOperation(HasOperationModels owner, OperationModel model) {
                if (model.getName().equals(operation.getName())) {
                    this.val$reference.set((Object)model);
                    this.stop();
                }
            }
        }.walk(extension));
    }

    public static NamedObject find(ExtensionModel extension, final SourceModel source) {
        return ExtensionModelUtils.doFind(extension.getName(), source.getName(), "SOURCE", reference -> new ExtensionWalker((Reference)reference){
            final /* synthetic */ Reference val$reference;
            {
                this.val$reference = reference;
            }

            protected void onSource(HasSourceModels owner, org.mule.runtime.api.meta.model.source.SourceModel model) {
                if (model.getName().equals(source.getName())) {
                    this.val$reference.set((Object)model);
                    this.stop();
                }
            }
        }.walk(extension));
    }

    private static NamedObject doFind(String extension, String component, String kind, Consumer<Reference<NamedObject>> consumer) {
        Reference reference = new Reference();
        consumer.accept((Reference<NamedObject>)reference);
        NamedObject result = (NamedObject)reference.get();
        if (result == null) {
            throw new IllegalStateException(String.format("Component [%s] of type [%s] was not found in extension [%s]", component, kind, extension));
        }
        return result;
    }

    private static org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor toArtifactBundleDescriptor(BundleDescriptor bundleDescriptor) {
        BundleDescriptor.Builder builder = new BundleDescriptor.Builder().setGroupId(bundleDescriptor.getGroupId()).setArtifactId(bundleDescriptor.getArtifactId()).setVersion(bundleDescriptor.getVersion()).setType(bundleDescriptor.getType());
        bundleDescriptor.getClassifier().ifPresent(classifier -> builder.setClassifier(classifier));
        return builder.build();
    }
}

