/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.session.validation;

import java.util.Optional;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.tooling.client.internal.session.validation.ComponentValidationContext;
import org.mule.tooling.client.internal.session.validation.SessionCallValidationException;
import org.mule.tooling.client.internal.session.validation.Validators;

public class ParameterExistsValidator
implements Validators.ComponentValidator {
    private String parameterName;
    private ParameterModel parameterModel;

    public ParameterExistsValidator(String parameterName) {
        this.parameterName = parameterName;
    }

    @Override
    public void validate(ComponentValidationContext<?> context) throws SessionCallValidationException {
        Optional<ParameterModel> parameterModel = context.getParameterizedModel().getAllParameterModels().stream().filter(p -> p.getName().equals(this.parameterName)).findAny();
        if (!parameterModel.isPresent()) {
            throw new SessionCallValidationException(String.format("Parameter: '%s' not found in Model: '%s' for extension: '%s'", this.parameterName, context.getComponentDeclaration().getName(), context.getComponentDeclaration().getDeclaringExtension()), "ParameterModel not found", "INVALID_PARAMETER");
        }
        this.parameterModel = parameterModel.get();
    }

    public ParameterModel getParameterModel() {
        if (this.parameterModel == null) {
            throw new RuntimeException("Model is not yet validated");
        }
        return this.parameterModel;
    }
}

