/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.session.mediator;

import org.mule.runtime.api.meta.model.parameter.FieldValueProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.runtime.module.extension.internal.loader.utils.FieldValueProviderNameUtils;
import org.mule.tooling.client.api.value.resolver.ValueResolverFailure;
import org.mule.tooling.client.api.value.resolver.ValueResolverResult;
import org.mule.tooling.client.internal.session.ConfigurationDeclarationProvider;
import org.mule.tooling.client.internal.session.mediator.resolver.ValuesResolverFactory;
import org.mule.tooling.client.internal.session.validation.ConnectionAndConfigurationValidator;
import org.mule.tooling.client.internal.session.validation.ParameterExistsValidator;
import org.mule.tooling.client.internal.session.validation.SessionCallValidationException;
import org.mule.tooling.client.internal.session.validation.SessionCallValidator;
import org.mule.tooling.client.internal.session.validation.Validators;
import org.mule.tooling.client.internal.session.validation.ValueProviderActingParametersValidator;

public class FieldValuesResolverModelMediator {
    private final ConfigurationDeclarationProvider configurationDeclarationProvider;
    private final SessionCallValidator sessionCallValidator;
    private final ParameterizedElementDeclaration parameterizedElementDeclaration;
    private final String parameterName;
    private final String targetSelector;
    private final ValueResolverResult failure;
    private Reference<ParameterizedModel> parameterizedModel = new Reference();
    private Reference<ParameterModel> parameterModel = new Reference();
    private FieldValueProviderModel fieldValueProviderModel;

    public FieldValuesResolverModelMediator(ConfigurationDeclarationProvider configurationDeclarationProvider, ParameterizedElementDeclaration elementDeclaration, SessionCallValidator sessionCallValidator, String parameterName, String targetSelector) {
        this.configurationDeclarationProvider = configurationDeclarationProvider;
        this.parameterizedElementDeclaration = elementDeclaration;
        this.parameterName = parameterName;
        this.sessionCallValidator = sessionCallValidator;
        this.targetSelector = targetSelector;
        this.failure = this.validateModel();
    }

    public ValueResolverResult resolve(ValuesResolverFactory valuesResolverFactory, boolean ignoreCache) {
        if (this.failure != null) {
            return this.failure;
        }
        return valuesResolverFactory.createFieldValueProviderResolver(this.parameterizedElementDeclaration, this.fieldValueProviderModel, ignoreCache).resolve((ParameterizedModel)this.parameterizedModel.get(), (ParameterModel)this.parameterModel.get(), this.parameterName);
    }

    private ValueResolverResult validateModel() {
        try {
            Reference requiresConfig = new Reference((Object)false);
            Reference requiresConnection = new Reference((Object)false);
            Validators.ComponentValidator[] componentValidatorArray = new Validators.ComponentValidator[3];
            componentValidatorArray[0] = c -> {
                this.parameterizedModel.set((Object)c.getParameterizedModel());
                ParameterExistsValidator parameterExistsValidator = new ParameterExistsValidator(this.parameterName);
                parameterExistsValidator.validate(c);
                this.parameterModel.set((Object)parameterExistsValidator.getParameterModel());
                if (!((ParameterModel)this.parameterModel.get()).getFieldValueProviderModels().isEmpty()) {
                    this.fieldValueProviderModel = ((ParameterModel)this.parameterModel.get()).getFieldValueProviderModels().stream().filter(m -> FieldValueProviderNameUtils.getParameterName((FieldValueProviderModel)m).equals(this.parameterName)).filter(m -> m.getTargetSelector().equals(this.targetSelector)).findAny().orElseThrow(() -> new SessionCallValidationException(String.format("Parameter: '%s' doesn't have a field value provider model defined for targetSelector: '%s' in Model: '%s' for extension: '%s'", this.parameterName, this.targetSelector, this.parameterizedElementDeclaration.getName(), this.parameterizedElementDeclaration.getDeclaringExtension()), "ParameterModel not found", "INVALID_PARAMETER"));
                    requiresConfig.set((Object)this.fieldValueProviderModel.requiresConfiguration());
                    requiresConnection.set((Object)this.fieldValueProviderModel.requiresConnection());
                }
            };
            componentValidatorArray[1] = new ValueProviderActingParametersValidator(this.parameterName);
            componentValidatorArray[2] = new ConnectionAndConfigurationValidator(this.parameterizedElementDeclaration, this.configurationDeclarationProvider, () -> ((Reference)requiresConnection).get(), () -> ((Reference)requiresConfig).get(), () -> String.format("Parameter: '%s' with targetSelector: '%s' on element : '%s' for extension: '%s'", this.parameterName, this.targetSelector, this.parameterizedElementDeclaration.getName(), this.parameterizedElementDeclaration.getDeclaringExtension()));
            this.sessionCallValidator.validateComponent(this.parameterizedElementDeclaration, componentValidatorArray);
        }
        catch (SessionCallValidationException e) {
            return ValueResolverResult.failure((ValueResolverFailure)new ValueResolverFailure(e.getMessage(), e.getReason(), e.getFailureCode()));
        }
        return null;
    }
}

