/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.artifact;

import java.io.InputStream;
import java.util.List;
import org.mule.maven.client.api.MavenClient;
import org.mule.runtime.api.app.declaration.serialization.ArtifactDeclarationJsonSerializer;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.config.api.dsl.ArtifactDeclarationXmlSerializer;
import org.mule.tooling.client.api.artifact.declaration.ArtifactSerializationException;
import org.mule.tooling.client.api.artifact.declaration.ArtifactSerializationService;
import org.mule.tooling.client.api.artifact.declaration.request.AbstractXmlArtifactRequest;
import org.mule.tooling.client.api.artifact.declaration.request.JsonArtifactDeserializationRequest;
import org.mule.tooling.client.api.artifact.declaration.request.JsonArtifactSerializationRequest;
import org.mule.tooling.client.api.artifact.declaration.request.XmlArtifactDeserializationRequest;
import org.mule.tooling.client.api.artifact.declaration.request.XmlArtifactSerializationRequest;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.MuleRuntimeExtensionModelProvider;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.utils.ExtensionModelUtils;

public class DefaultArtifactSerializationService
implements ArtifactSerializationService,
Command {
    private final List<ExtensionModel> muleModels;
    private final MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider;
    private final MavenClient mavenClient;
    private final Serializer serializer;

    public DefaultArtifactSerializationService(List<ExtensionModel> muleModels, MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider, MavenClient mavenClient, Serializer serializer) {
        this.muleModels = muleModels;
        this.muleRuntimeExtensionModelProvider = muleRuntimeExtensionModelProvider;
        this.mavenClient = mavenClient;
        this.serializer = serializer;
    }

    public String toXml(XmlArtifactSerializationRequest request) {
        Preconditions.checkArgument((request != null ? 1 : 0) != 0, (String)"Serialization request cannot be null");
        Preconditions.checkArgument((request.getArtifactDeclaration() != null ? 1 : 0) != 0, (String)"Missing ArtifactDeclaration to serialize. None was found in the given request");
        Preconditions.checkArgument((request.getPluginArtifactDescriptors() != null ? 1 : 0) != 0, (String)"pluginArtifactDescriptors cannot be null");
        try {
            return ArtifactDeclarationXmlSerializer.getDefault((DslResolvingContext)this.createDslResolvingContext((AbstractXmlArtifactRequest)request)).serialize(request.getArtifactDeclaration());
        }
        catch (Exception e) {
            throw new ArtifactSerializationException("An error occurred while serializing the ArtifactDeclaration", (Throwable)e);
        }
    }

    public ArtifactDeclaration fromXml(XmlArtifactDeserializationRequest request) {
        ArtifactDeclaration artifactDeclaration;
        block8: {
            Preconditions.checkArgument((request != null ? 1 : 0) != 0, (String)"Deserialization request cannot be null");
            Preconditions.checkArgument((request.getPluginArtifactDescriptors() != null ? 1 : 0) != 0, (String)"pluginArtifactDescriptors cannot be null");
            Preconditions.checkArgument((request.getArtifactSource() != null ? 1 : 0) != 0, (String)"Missing ArtifactSource to deserialize. None was found in the given request");
            InputStream inputStream = request.getArtifactSource();
            try {
                artifactDeclaration = ArtifactDeclarationXmlSerializer.getDefault((DslResolvingContext)this.createDslResolvingContext((AbstractXmlArtifactRequest)request)).deserialize(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ArtifactSerializationException("An error occurred while deserializing the ArtifactDeclaration", (Throwable)e);
                }
            }
            inputStream.close();
        }
        return artifactDeclaration;
    }

    public String toJson(JsonArtifactSerializationRequest request) {
        Preconditions.checkArgument((request != null ? 1 : 0) != 0, (String)"Serialization request cannot be null");
        Preconditions.checkArgument((request.getArtifactDeclaration() != null ? 1 : 0) != 0, (String)"Missing ArtifactDeclaration to serialize. None was found in the given request");
        try {
            return ArtifactDeclarationJsonSerializer.getDefault((boolean)request.isPrettyPrint()).serialize(request.getArtifactDeclaration());
        }
        catch (Exception e) {
            throw new ArtifactSerializationException("An error occurred while serializing the ArtifactDeclaration", (Throwable)e);
        }
    }

    public ArtifactDeclaration fromJson(JsonArtifactDeserializationRequest request) {
        Preconditions.checkArgument((request != null ? 1 : 0) != 0, (String)"Serialization request cannot be null");
        Preconditions.checkArgument((request.getArtifactSource() != null && !request.getArtifactSource().trim().isEmpty() ? 1 : 0) != 0, (String)"Missing ArtifactDeclaration source to deserialize. None was found in the given request");
        try {
            return ArtifactDeclarationJsonSerializer.getDefault((boolean)false).deserialize(request.getArtifactSource());
        }
        catch (Exception e) {
            throw new ArtifactSerializationException("An error occurred while deserializing the ArtifactDeclaration", (Throwable)e);
        }
    }

    private DslResolvingContext createDslResolvingContext(AbstractXmlArtifactRequest request) {
        List<ExtensionModel> plugins = ExtensionModelUtils.resolveExtensionModels(this.mavenClient, this.muleRuntimeExtensionModelProvider, ExtensionModelUtils.toBundleDescriptors(request.getPluginArtifactDescriptors()));
        return ExtensionModelUtils.createDslResolvingContext(this.muleModels, plugins);
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "toXml": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(XmlArtifactSerializationRequest.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return this.serializer.serialize((Object)this.toXml((XmlArtifactSerializationRequest)this.serializer.deserialize(arguments[0])));
            }
            case "fromXml": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(XmlArtifactDeserializationRequest.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return this.serializer.serialize((Object)this.fromXml((XmlArtifactDeserializationRequest)this.serializer.deserialize(arguments[0])));
            }
            case "toJson": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(JsonArtifactSerializationRequest.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return this.serializer.serialize((Object)this.toJson((JsonArtifactSerializationRequest)this.serializer.deserialize(arguments[0])));
            }
            case "fromJson": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(JsonArtifactDeserializationRequest.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return this.serializer.serialize((Object)this.fromJson((JsonArtifactDeserializationRequest)this.serializer.deserialize(arguments[0])));
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }
}

