/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.util;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.mule.framework.api.MuleFramework;
import org.mule.framework.api.exception.IllegalParametersException;
import org.mule.framework.api.extension.config.ConfigurationHandler;
import org.mule.framework.internal.extension.config.InternalConfigurationHandler;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParametersResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeValueResolverWrapper;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MuleFrameworkUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleFrameworkUtils.class);

    private MuleFrameworkUtils() {
    }

    public static ExtensionModel getExtensionModel(MuleFramework muleFramework, String extensionName) {
        return (ExtensionModel)muleFramework.getExtensionModel(extensionName).orElseThrow(() -> new IllegalParametersException(String.format("Extension '%s' is not registered in this framework instance", extensionName)));
    }

    public static void assertExtensionModelLoader(MuleFramework muleFramework, String extensionName) {
        MuleFrameworkUtils.getExtensionModel(muleFramework, extensionName);
    }

    public static <M extends ComponentModel> ParameterValueResolver toParameterValueResolver(ComponentParameterization<M> parameterization) {
        Map<String, Object> map = parameterization.getParameters().entrySet().stream().collect(Collectors.toMap(entry -> ((ParameterModel)((Pair)entry.getKey()).getSecond()).getName(), Map.Entry::getValue));
        return StaticParameterValueResolver.from(map);
    }

    public static ResolverSet toResolverSet(Map<String, ?> values, ParameterizedModel parameterizedModel, MuleContext muleContext, ReflectionCache reflectionCache, ExpressionManager expressionManager) throws Exception {
        ParametersResolver parametersResolver = ParametersResolver.fromValues(values, (MuleContext)muleContext, (boolean)true, (ReflectionCache)reflectionCache, (ExpressionManager)expressionManager, (String)parameterizedModel.getName());
        ResolverSet typeUnsafeResolverSet = parametersResolver.getParametersAsResolverSet(muleContext, parameterizedModel, parameterizedModel.getParameterGroupModels());
        Map paramModels = parameterizedModel.getAllParameterModels().stream().collect(Collectors.toMap(p -> p.getName(), Function.identity()));
        ResolverSet typeSafeResolverSet = new ResolverSet(muleContext);
        typeUnsafeResolverSet.getResolvers().forEach((paramName, resolver) -> {
            Optional clazz;
            ParameterModel model = (ParameterModel)paramModels.get(paramName);
            if (model != null && (clazz = ExtensionMetadataTypeUtils.getType((MetadataType)model.getType())).isPresent()) {
                resolver = new TypeSafeValueResolverWrapper(resolver, (Class)clazz.get());
            }
            typeSafeResolverSet.add(paramName, resolver);
        });
        typeSafeResolverSet.initialise();
        return typeSafeResolverSet;
    }

    public static void stopAndDispose(Object object) {
        if (object == null) {
            return;
        }
        try {
            LifecycleUtils.stopIfNeeded((Object)object);
        }
        catch (MuleException e) {
            LOGGER.error("Exception trying to stop " + object, (Throwable)e);
        }
        finally {
            LifecycleUtils.disposeIfNeeded((Object)object, (Logger)LOGGER);
        }
    }

    public static InternalConfigurationHandler asInternal(ConfigurationHandler configurationHandler) {
        if (configurationHandler instanceof InternalConfigurationHandler) {
            return (InternalConfigurationHandler)configurationHandler;
        }
        throw new IllegalArgumentException("Invalid ConfigurationHandler implementation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<ConnectionProvider> getConnectionProvider(Optional<ConfigurationHandler> optionalConfigurationHandler, MuleContext muleContext) {
        CoreEvent nullEvent = CoreEvent.nullEvent();
        try {
            Optional<ConnectionProvider> optional = optionalConfigurationHandler.flatMap(arg_0 -> MuleFrameworkUtils.lambda$getConnectionProvider$4((Event)nullEvent, arg_0));
            return optional;
        }
        finally {
            ((BaseEventContext)nullEvent.getContext()).success();
        }
    }

    public static Supplier<Object> connectionSupplier(Optional<ConfigurationHandler> configurationHandler, MuleContext muleContext) {
        return () -> {
            Optional<ConnectionProvider> connectionProvider = MuleFrameworkUtils.getConnectionProvider(configurationHandler, muleContext);
            return connectionProvider.isPresent() ? connectionProvider.get().connect() : null;
        };
    }

    public static Supplier<Object> configSupplier(Optional<ConfigurationHandler> optionalConfigurationHandler, MuleContext muleContext) {
        return () -> {
            CoreEvent nullEvent = CoreEvent.nullEvent();
            try {
                Object var2_2 = optionalConfigurationHandler.map(arg_0 -> MuleFrameworkUtils.lambda$configSupplier$6((Event)nullEvent, arg_0)).orElse(null);
                return var2_2;
            }
            finally {
                ((BaseEventContext)nullEvent.getContext()).success();
            }
        };
    }

    public static boolean mustOverrideArtifact(BundleDescriptor currentDependency, BundleDescriptor newDependency) {
        DefaultArtifactVersion newDependencyVersion;
        DefaultArtifactVersion currentDependencyVersion = new DefaultArtifactVersion(currentDependency.getVersion());
        if (MuleFrameworkUtils.isGreaterVersion(currentDependencyVersion, newDependencyVersion = new DefaultArtifactVersion(newDependency.getVersion()))) {
            if (currentDependencyVersion.getMajorVersion() != newDependencyVersion.getMajorVersion()) {
                throw new IllegalArgumentException("Cannot override major version of a dependency. Dependency: " + currentDependency.getArtifactId() + ". Current version: " + currentDependency.getVersion() + ". New version: " + newDependency.getVersion());
            }
            return true;
        }
        return false;
    }

    private static boolean isGreaterVersion(DefaultArtifactVersion actualDependency, DefaultArtifactVersion transitiveDependency) {
        return actualDependency.compareTo((ArtifactVersion)transitiveDependency) < 0;
    }

    private static /* synthetic */ Object lambda$configSupplier$6(Event nullEvent, ConfigurationHandler configurationHandler) {
        return MuleFrameworkUtils.asInternal(configurationHandler).getConfigurationProvider().get(nullEvent).getValue();
    }

    private static /* synthetic */ Optional lambda$getConnectionProvider$4(Event nullEvent, ConfigurationHandler configurationHandler) {
        return MuleFrameworkUtils.asInternal(configurationHandler).getConfigurationProvider().get(nullEvent).getConnectionProvider();
    }
}

