/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.value;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.framework.api.extension.config.ConfigurationHandler;
import org.mule.framework.api.tooling.value.ValueProviderSession;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.tooling.value.ValueProviderExecutor;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public class DietValueProviderSession
implements ValueProviderSession {
    private final InternalMuleFramework muleFramework;
    private final ExtensionModel extensionModel;
    private final ParameterizedModel parameterizedModel;
    private final ValueProviderExecutor valueProviderExecutor;

    public DietValueProviderSession(InternalMuleFramework muleFramework, ExtensionModel extensionModel, ParameterizedModel parameterizedModel, ReflectionCache reflectionCache) {
        this.muleFramework = muleFramework;
        this.extensionModel = extensionModel;
        this.parameterizedModel = parameterizedModel;
        this.valueProviderExecutor = new ValueProviderExecutor(muleFramework.getMuleContext(), muleFramework.getExpressionManager(), reflectionCache, parameterizedModel);
    }

    public Map<Pair<String, ParameterModel>, ValueProviderModel> getValueProviderModels() {
        return this.parameterizedModel.getParameterGroupModels().stream().flatMap(parameterGroup -> parameterGroup.getParameterModels().stream().filter(parameterModel -> parameterModel.getValueProviderModel().isPresent()).map(p -> new Pair((Object)parameterGroup.getName(), p))).collect(Collectors.toMap(Function.identity(), pair -> (ValueProviderModel)((ParameterModel)pair.getSecond()).getValueProviderModel().get()));
    }

    public ValueResult resolveValues(String providerName, ComponentParameterization actingParameters, Optional<ConfigurationHandler> configurationHandler) {
        return this.valueProviderExecutor.resolveValues(this.extensionModel, providerName, actingParameters, configurationHandler);
    }

    public ValueResult resolveValues(String providerName, ComponentParameterization actingParameters, String configName) {
        ConfigurationHandler configurationHandler = this.muleFramework.getConfigurationHandler(configName).orElseThrow(() -> new IllegalArgumentException(String.format("No config with name '%s' is registered on this instance", configName)));
        return this.resolveValues(providerName, actingParameters, Optional.of(configurationHandler));
    }

    public void close() throws Exception {
    }
}

