/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.resolution;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.framework.internal.tooling.type.resolution.ExpressionNotSupportedException;
import org.mule.framework.internal.tooling.type.resolution.MetadataKeyResult;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataKeyDeclarationResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataKeyDeclarationResolver.class);
    private final ComponentModel componentModel;
    private final Map<Pair<String, String>, Object> componentParameters;
    private ExpressionManager expressionManager;

    public MetadataKeyDeclarationResolver(ComponentModel componentModel, Map<Pair<String, String>, Object> componentParameters) {
        this.componentModel = componentModel;
        this.componentParameters = componentParameters;
    }

    public MetadataKeyDeclarationResolver(ComponentModel componentModel, Map<Pair<String, String>, Object> componentParameters, ExpressionManager expressionManager) {
        this(componentModel, componentParameters);
        this.expressionManager = expressionManager;
    }

    public MetadataKey resolvePartialKey() throws ExpressionNotSupportedException {
        return this.metadataKeyResult(true).getMetadataKey();
    }

    public MetadataKeyResult resolveKeyResult() throws ExpressionNotSupportedException {
        return this.metadataKeyResult(false);
    }

    public MetadataKeyResult metadataKeyResult(boolean partialKey) throws ExpressionNotSupportedException {
        List<MetadataKeyInfo> keyPartModelsInfo = this.getMetadataKeyPartsInfo();
        if (keyPartModelsInfo.isEmpty()) {
            return new MetadataKeyResult(MetadataKeyBuilder.newKey((String)"").build());
        }
        MetadataKeyBuilder rootMetadataKeyBuilder = null;
        MetadataKeyBuilder metadataKeyBuilder = null;
        Map<String, Object> keyPartValues = this.getMetadataKeyPartsValuesFromParameters();
        for (MetadataKeyInfo keyInfo : keyPartModelsInfo) {
            String id = null;
            boolean isNullValue = false;
            if (keyPartValues.containsKey(keyInfo.parameterModel.getName())) {
                id = keyPartValues.get(keyInfo.parameterModel.getName()).toString();
                isNullValue = id == null;
            } else {
                if (partialKey || keyInfo.parameterModel.getDefaultValue() == null) break;
                String defaultValue = keyInfo.parameterModel.getDefaultValue().toString();
                if (this.expressionManager != null && MetadataKeyDeclarationResolver.isExpression(defaultValue)) {
                    try {
                        id = this.expressionManager.evaluate(defaultValue, DataType.STRING).getValue().toString();
                    }
                    catch (ExpressionRuntimeException e) {
                        LOGGER.warn(String.format("Couldn't resolve expression default value for parameter: '%s' which is defined as MetadataKeyPart", keyInfo.parameterModel.getName()), (Throwable)e);
                    }
                } else {
                    id = defaultValue;
                }
            }
            if (id == null && !isNullValue) continue;
            if (metadataKeyBuilder == null) {
                rootMetadataKeyBuilder = metadataKeyBuilder = MetadataKeyBuilder.newKey((String)id).withPartName(keyInfo.parameterModel.getName());
                continue;
            }
            MetadataKeyBuilder metadataKeyChildBuilder = MetadataKeyBuilder.newKey((String)id).withPartName(keyInfo.parameterModel.getName());
            metadataKeyBuilder.withChild(metadataKeyChildBuilder);
            metadataKeyBuilder = metadataKeyChildBuilder;
        }
        List missingPartsInfo = keyPartModelsInfo.stream().filter(ki -> ((MetadataKeyInfo)ki).parameterModel.isRequired() && !keyPartValues.containsKey(((MetadataKeyInfo)ki).parameterModel.getName())).collect(Collectors.toList());
        String partialMessage = null;
        MetadataKey metadataKey = MetadataKeyBuilder.newKey((String)"").build();
        if (!missingPartsInfo.isEmpty()) {
            MetadataKeyInfo firstKeyPartInfo = (MetadataKeyInfo)missingPartsInfo.get(0);
            partialMessage = missingPartsInfo.size() == 1 && firstKeyPartInfo.level == 1 && firstKeyPartInfo.totalLevels == 1 ? String.format("Missing MetadataKey: %s", firstKeyPartInfo.parameterModel.getName()) : String.format("The given MetadataKey does not provide all the required levels. Missing levels: %s", missingPartsInfo.stream().map(ki -> ((MetadataKeyInfo)ki).parameterModel.getName()).collect(Collectors.toList()));
        }
        if (metadataKeyBuilder != null) {
            metadataKey = rootMetadataKeyBuilder.build();
        }
        return new MetadataKeyResult(metadataKey, partialMessage);
    }

    private List<MetadataKeyInfo> getMetadataKeyPartsInfo() {
        LinkedList<MetadataKeyInfo> metadataKeyPartsInfo = new LinkedList<MetadataKeyInfo>();
        this.componentModel.getParameterGroupModels().forEach(pg -> {
            List<ParameterModel> keysInGroup = pg.getParameterModels().stream().filter(pm -> pm.getModelProperty(MetadataKeyPartModelProperty.class).isPresent()).sorted(Comparator.comparingInt(p -> ((MetadataKeyPartModelProperty)p.getModelProperty(MetadataKeyPartModelProperty.class).get()).getOrder())).collect(Collectors.toList());
            keysInGroup.forEach(k -> metadataKeyPartsInfo.add(new MetadataKeyInfo((ParameterModel)k, ((MetadataKeyPartModelProperty)k.getModelProperty(MetadataKeyPartModelProperty.class).get()).getOrder(), keysInGroup.size())));
        });
        return metadataKeyPartsInfo;
    }

    private Map<String, Object> getMetadataKeyPartsValuesFromParameters() throws ExpressionNotSupportedException {
        HashMap<String, Object> metadataKeyPartsValues = new HashMap<String, Object>();
        for (ParameterGroupModel parameterGroupModel : this.componentModel.getParameterGroupModels()) {
            for (ParameterModel parameterModel : parameterGroupModel.getParameterModels()) {
                Pair groupParamName = new Pair((Object)parameterGroupModel.getName(), (Object)parameterModel.getName());
                if (!this.componentParameters.containsKey(groupParamName) || !parameterModel.getModelProperty(MetadataKeyPartModelProperty.class).isPresent()) continue;
                if (!parameterModel.getExpressionSupport().equals((Object)ExpressionSupport.NOT_SUPPORTED) && MetadataKeyDeclarationResolver.isExpression(this.componentParameters.get(groupParamName))) {
                    throw new ExpressionNotSupportedException(String.format("Error resolving value for parameter: '%s' in group '%s' from declaration, it cannot be an EXPRESSION value", parameterModel.getName(), parameterGroupModel.getName()));
                }
                metadataKeyPartsValues.put(parameterModel.getName(), this.componentParameters.get(groupParamName));
            }
        }
        return metadataKeyPartsValues;
    }

    private static boolean isExpression(Object value) {
        if (value instanceof String) {
            String trim = ((String)value).trim();
            return trim.startsWith("#[") && trim.endsWith("]");
        }
        return false;
    }

    private static class MetadataKeyInfo {
        private final int level;
        private final int totalLevels;
        private final ParameterModel parameterModel;

        private MetadataKeyInfo(ParameterModel parameterModel, int level, int totalLevels) {
            this.parameterModel = parameterModel;
            this.level = level;
            this.totalLevels = totalLevels;
        }
    }
}

