/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.resolution;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.framework.api.extension.config.ConfigurationHandler;
import org.mule.framework.api.tooling.type.resolution.TypeResolutionContext;
import org.mule.framework.api.tooling.type.resolution.TypeResolutionSession;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.tooling.type.resolution.ExpressionNotSupportedException;
import org.mule.framework.internal.tooling.type.resolution.MetadataKeyDeclarationResolver;
import org.mule.framework.internal.tooling.type.resolution.MetadataKeyResult;
import org.mule.framework.internal.tooling.type.resolution.SerializableMetadataKeyResult;
import org.mule.framework.internal.tooling.type.resolution.SerilizableComponentTypeResult;
import org.mule.framework.internal.util.MuleFrameworkUtils;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.MetadataCache;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.MetadataStorage;
import org.mule.runtime.api.metadata.MetadataStorageToCacheAdapter;
import org.mule.runtime.api.metadata.RouterOutputMetadataContext;
import org.mule.runtime.api.metadata.ScopeOutputMetadataContext;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataTypesDescriptor;
import org.mule.runtime.api.metadata.descriptor.InputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.metadata.api.cache.ComponentParameterizationMetadataCacheIdGenerator;
import org.mule.runtime.metadata.api.cache.MetadataCacheId;
import org.mule.runtime.module.extension.internal.metadata.DefaultMetadataContext;
import org.mule.runtime.module.extension.internal.metadata.MetadataMediator;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DietTypeResolutionSession
implements TypeResolutionSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(DietTypeResolutionSession.class);
    private final ExtensionModel extensionModel;
    private final ComponentModel componentModel;
    private final InternalMuleFramework mule;
    private final MetadataMediator mediator;
    private final ClassTypeLoader typeLoader;
    private final MetadataStorage metadataStorage;
    private final MetadataStorageToCacheAdapter metadataCacheAdapter;
    private final ComponentParameterizationMetadataCacheIdGenerator idGenerator;

    public DietTypeResolutionSession(InternalMuleFramework mule, String extensionName, ComponentModel componentModel) {
        this.extensionModel = MuleFrameworkUtils.getExtensionModel(mule, extensionName);
        this.componentModel = componentModel;
        this.mule = mule;
        this.mediator = new MetadataMediator(componentModel);
        this.typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(MuleExtensionUtils.getClassLoader((ExtensionModel)this.extensionModel));
        this.metadataStorage = mule.getMetadataStorage();
        this.metadataCacheAdapter = new MetadataStorageToCacheAdapter(this.metadataStorage);
        this.idGenerator = mule.getIdGenerator();
    }

    private MetadataResult<MetadataKeysContainer> doGetMetadataKeys(ComponentParameterization<ComponentModel> parameterization, Optional<ConfigurationHandler> configurationHandler) {
        MetadataContext context = this.createMetadataContext(configurationHandler);
        return (MetadataResult)ClassUtils.withContextClassLoader((ClassLoader)this.mule.getExecutionClassLoader(), () -> this.mediator.getMetadataKeys(context, MuleFrameworkUtils.toParameterValueResolver(parameterization), this.mule.getReflectionCache()));
    }

    public MetadataResult<MetadataKeysContainer> getMetadataKeys(ComponentParameterization<ComponentModel> parameterization, Optional<ConfigurationHandler> configurationHandler) throws MetadataResolvingException, ConnectionException {
        this.validateParameterization(parameterization);
        Optional<String> cacheId = this.idGenerator.getIdForMetadataKeys(parameterization).map(MetadataCacheId::getValue);
        if (cacheId.isPresent()) {
            SerializableMetadataKeyResult serializableResult = (SerializableMetadataKeyResult)this.metadataStorage.computeIfAbsent((Serializable)((Object)cacheId.get()), id -> new SerializableMetadataKeyResult(this.doGetMetadataKeys(parameterization, configurationHandler)));
            return serializableResult.toKeysMetadataResult();
        }
        return this.doGetMetadataKeys(parameterization, configurationHandler);
    }

    public MetadataResult<MetadataKeysContainer> getMetadataKeys(ComponentParameterization<ComponentModel> parameterization, String configName) throws MetadataResolvingException, ConnectionException {
        ConfigurationHandler configurationHandler = this.mule.getConfigurationHandler(configName).orElseThrow(() -> new IllegalArgumentException(String.format("No config with name '%s' is registered on this instance", configName)));
        return this.getMetadataKeys(parameterization, Optional.of(configurationHandler));
    }

    public <T extends ComponentModel> MetadataResult<ComponentMetadataTypesDescriptor> resolveComponentTypes(ComponentParameterization<T> parameterization, Optional<ConfigurationHandler> configurationHandler, TypeResolutionContext typeResolutionContext) throws MetadataResolvingException, ConnectionException {
        this.validateParameterization(parameterization);
        Optional<String> cacheId = this.idGenerator.getIdForComponentMetadata(parameterization).map(MetadataCacheId::getValue);
        if (cacheId.isPresent()) {
            SerilizableComponentTypeResult serializableResult = (SerilizableComponentTypeResult)this.metadataStorage.computeIfAbsent((Serializable)((Object)cacheId.get()), id -> new SerilizableComponentTypeResult(this.doResolveComponentTypes(parameterization, configurationHandler, typeResolutionContext)));
            return serializableResult.toKeysMetadataResult();
        }
        return this.doResolveComponentTypes(parameterization, configurationHandler, typeResolutionContext);
    }

    public <T extends ComponentModel> MetadataResult<ComponentMetadataTypesDescriptor> resolveComponentTypes(ComponentParameterization<T> parameterization, String configName, TypeResolutionContext typeResolutionContext) throws MetadataResolvingException, ConnectionException {
        ConfigurationHandler configurationHandler = this.mule.getConfigurationHandler(configName).orElseThrow(() -> new IllegalArgumentException(String.format("No config with name '%s' is registered on this instance", configName)));
        return this.resolveComponentTypes(parameterization, Optional.of(configurationHandler), typeResolutionContext);
    }

    private <T extends ComponentModel> MetadataResult<ComponentMetadataTypesDescriptor> doResolveComponentTypes(ComponentParameterization<T> parameterization, Optional<ConfigurationHandler> configurationHandler, TypeResolutionContext typeResolutionContext) {
        MetadataKeyResult metadataKeyResult;
        try {
            metadataKeyResult = new MetadataKeyDeclarationResolver(this.componentModel, parameterization.getParameters().entrySet().stream().collect(Collectors.toMap(e -> new Pair((Object)((ParameterGroupModel)((Pair)e.getKey()).getFirst()).getName(), (Object)((ParameterModel)((Pair)e.getKey()).getSecond()).getName()), e -> e.getValue())), this.mule.getExpressionManager()).resolveKeyResult();
        }
        catch (ExpressionNotSupportedException e2) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e2).withFailureCode(FailureCode.INVALID_METADATA_KEY).onKeys()});
        }
        if (!metadataKeyResult.isComplete()) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(metadataKeyResult.getPartialReason()).withFailureCode(FailureCode.INVALID_METADATA_KEY).onComponent()});
        }
        MetadataKey metadataKey = metadataKeyResult.getMetadataKey();
        LOGGER.debug("Invoking connector's component metadata resolver for component: {} with key: {}", (Object)this.componentModel.getName(), (Object)metadataKey);
        return (MetadataResult)ClassUtils.withContextClassLoader((ClassLoader)MuleExtensionUtils.getClassLoader((ExtensionModel)this.extensionModel), () -> {
            try {
                MetadataContext metadataContext = this.createMetadataContext(configurationHandler, typeResolutionContext.getScopeOutputMetadataContext(), typeResolutionContext.getRouterOutputMetadataContext());
                MetadataResult inputMetadata = this.mediator.getInputMetadata(metadataContext, metadataKey);
                MetadataResult outputMetadata = this.mediator.getOutputMetadata(metadataContext, metadataKey);
                return this.collectMetadata((MetadataResult<InputMetadataDescriptor>)inputMetadata, (MetadataResult<OutputMetadataDescriptor>)outputMetadata);
            }
            catch (Exception e) {
                return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onComponent()});
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<ConfigurationInstance> resolveConfiguration(Optional<ConfigurationHandler> configurationHandler) {
        CoreEvent event = CoreEvent.nullEvent();
        try {
            Optional<ConfigurationInstance> optional = configurationHandler.map(h -> MuleFrameworkUtils.asInternal(h).getConfigurationProvider().get((Event)event));
            return optional;
        }
        finally {
            ((BaseEventContext)event.getContext()).success();
        }
    }

    private MetadataResult<ComponentMetadataTypesDescriptor> collectMetadata(MetadataResult<InputMetadataDescriptor> inputMetadataResult, MetadataResult<OutputMetadataDescriptor> outputMetadataResult) {
        if (inputMetadataResult.isSuccess() && (outputMetadataResult == null || outputMetadataResult.isSuccess())) {
            ComponentMetadataTypesDescriptor.ComponentMetadataTypesDescriptorBuilder builder = ComponentMetadataTypesDescriptor.builder().keepNonDynamicMetadata(true).withInputMetadataDescriptor((InputMetadataDescriptor)inputMetadataResult.get());
            if (outputMetadataResult != null) {
                builder.withOutputMetadataDescriptor((OutputMetadataDescriptor)outputMetadataResult.get());
            }
            return MetadataResult.success((Object)builder.build());
        }
        ArrayList failures = new ArrayList(inputMetadataResult.getFailures());
        if (outputMetadataResult != null) {
            failures.addAll(outputMetadataResult.getFailures());
        }
        return MetadataResult.failure(failures);
    }

    private MetadataContext createMetadataContext(Optional<ConfigurationHandler> configurationHandler, Optional<ScopeOutputMetadataContext> scopeOutputMetadataContext, Optional<RouterOutputMetadataContext> routerOutputMetadataContext) {
        Optional<ConfigurationInstance> config = this.resolveConfiguration(configurationHandler);
        return new DefaultMetadataContext(() -> config, this.mule.getConnectionManager(), (MetadataCache)this.metadataCacheAdapter, this.typeLoader, scopeOutputMetadataContext, routerOutputMetadataContext);
    }

    private MetadataContext createMetadataContext(Optional<ConfigurationHandler> configurationHandler) {
        return this.createMetadataContext(configurationHandler, Optional.empty(), Optional.empty());
    }

    private <T extends ComponentModel> void validateParameterization(ComponentParameterization<T> parameterization) {
        if (parameterization.getModel() != this.componentModel) {
            throw new IllegalArgumentException("Supplied parameterization points to a ComponentModel different than the one supplied upon creation of this session");
        }
    }

    public void close() throws Exception {
    }
}

