/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation.utils;

import java.util.HashSet;
import java.util.Set;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.runtime.api.component.ComponentIdentifier;

public class CoreUtils {
    public static final String MULE_NAMESPACE = "mule";
    public static final String EE_NAMESPACE = "ee";
    public static final ComponentIdentifier SET_PAYLOAD_IDENTIFIER = ComponentIdentifier.builder().name("set-payload").namespace("mule").build();
    public static final ComponentIdentifier SET_VARIABLE_IDENTIFIER = ComponentIdentifier.builder().name("set-variable").namespace("mule").build();
    public static final ComponentIdentifier REMOVE_VARIABLE_IDENTIFIER = ComponentIdentifier.builder().name("remove-variable").namespace("mule").build();
    public static final ComponentIdentifier EE_TRANSFORM_IDENTIFIER = ComponentIdentifier.builder().name("transform").namespace("ee").build();
    public static final ComponentIdentifier LOGGER_IDENTIFIER = ComponentIdentifier.builder().name("logger").namespace("mule").build();
    public static final ComponentIdentifier FLOW_REF_IDENTIFIER = ComponentIdentifier.builder().name("flow-ref").namespace("mule").build();
    public static final ComponentIdentifier FOREACH_IDENTIFIER = ComponentIdentifier.builder().name("foreach").namespace("mule").build();
    public static final ComponentIdentifier PARALLEL_FOREACH_IDENTIFIER = ComponentIdentifier.builder().name("parallel-foreach").namespace("mule").build();
    public static final ComponentIdentifier SCATTER_GATHER = ComponentIdentifier.builder().name("scatter-gather").namespace("mule").build();
    public static final ComponentIdentifier ASYNC_IDENTIFIER = ComponentIdentifier.builder().name("async").namespace("mule").build();
    public static final ComponentIdentifier ROUND_ROBIN_IDENTIFIER = ComponentIdentifier.builder().name("round-robin").namespace("mule").build();
    public static final ComponentIdentifier CHOICE_IDENTIFIER = ComponentIdentifier.builder().name("choice").namespace("mule").build();
    public static final ComponentIdentifier FIRST_SUCCESSFUL = ComponentIdentifier.builder().name("first-successful").namespace("mule").build();
    public static final ComponentIdentifier BATCH_JOB_IDENTIFIER = ComponentIdentifier.builder().name("job").namespace("batch").build();
    public static final ComponentIdentifier BATCH_ON_COMPLETE_IDENTIFIER = ComponentIdentifier.builder().name("on-complete").namespace("batch").build();
    public static final ComponentIdentifier BATCH_AGGREGATOR_IDENTIFIER = ComponentIdentifier.builder().name("aggregator").namespace("batch").build();
    private static final Set<ComponentIdentifier> COMBINABLE = new HashSet<ComponentIdentifier>();
    private static final Set<ComponentIdentifier> SPECIAL_HANDLING = new HashSet<ComponentIdentifier>();

    private CoreUtils() {
    }

    public static boolean isCombinableVariablesIdentifier(ComponentIdentifier identifier) {
        return COMBINABLE.contains(identifier);
    }

    public static boolean requiresSpecialHandling(ComponentIdentifier identifier) {
        return SPECIAL_HANDLING.contains(identifier);
    }

    public static boolean belongsToMule(ComponentIdentifier identifier) {
        return identifier.getNamespace().equals(MULE_NAMESPACE) || identifier.getNamespace().equals(EE_NAMESPACE);
    }

    public static MetadataType batchResultInput() {
        ObjectTypeBuilder builder = new BaseTypeBuilder(MetadataFormat.JAVA).objectType();
        NumberType numberType = new BaseTypeBuilder(MetadataFormat.JAVA).numberType().build();
        DefaultStringType stringType = new BaseTypeBuilder(MetadataFormat.JAVA).stringType().build();
        BooleanType booleanType = new BaseTypeBuilder(MetadataFormat.JAVA).booleanType().build();
        AnyType exceptionType = new BaseTypeBuilder(MetadataFormat.JAVA).anyType().build();
        builder.addField().key("elapsedTimeInMillis").value((MetadataType)numberType).required();
        builder.addField().key("successfulRecords").value((MetadataType)numberType).required();
        builder.addField().key("failedRecords").value((MetadataType)numberType).required();
        builder.addField().key("totalRecords").value((MetadataType)numberType).required();
        builder.addField().key("loadedRecords").value((MetadataType)numberType).required();
        builder.addField().key("processedRecords").value((MetadataType)numberType).required();
        builder.addField().key("getBatchJobInstanceId").value((MetadataType)stringType).required();
        builder.addField().key("failedOnInputPhase").value((MetadataType)booleanType).required();
        builder.addField().key("failedOnLoadingPhase").value((MetadataType)booleanType).required();
        builder.addField().key("failedOnCompletePhase").value((MetadataType)booleanType).required();
        builder.addField().key("inputPhaseException").value((MetadataType)exceptionType);
        builder.addField().key("loadingPhaseException").value((MetadataType)exceptionType);
        builder.addField().key("onCompletePhaseException").value((MetadataType)exceptionType);
        return builder.build();
    }

    static {
        COMBINABLE.add(SCATTER_GATHER);
        COMBINABLE.add(PARALLEL_FOREACH_IDENTIFIER);
        COMBINABLE.add(ROUND_ROBIN_IDENTIFIER);
        COMBINABLE.add(CHOICE_IDENTIFIER);
        COMBINABLE.add(FIRST_SUCCESSFUL);
        SPECIAL_HANDLING.add(SET_VARIABLE_IDENTIFIER);
        SPECIAL_HANDLING.add(REMOVE_VARIABLE_IDENTIFIER);
        SPECIAL_HANDLING.add(SET_PAYLOAD_IDENTIFIER);
        SPECIAL_HANDLING.add(EE_TRANSFORM_IDENTIFIER);
        SPECIAL_HANDLING.add(LOGGER_IDENTIFIER);
        SPECIAL_HANDLING.add(FOREACH_IDENTIFIER);
    }
}

