/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation.legacy;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.mule.datasense.api.metadataprovider.ApplicationModel;
import org.mule.datasense.api.metadataprovider.CachedDataSenseProvider;
import org.mule.datasense.api.metadataprovider.DataSenseConfiguration;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataProvider;
import org.mule.datasense.api.metadataprovider.DataSenseProvider;
import org.mule.datasense.api.metadataprovider.DefaultApplicationModel;
import org.mule.datasense.api.metadataprovider.DefaultDataSenseProvider;
import org.mule.datasense.impl.DefaultDataSense;
import org.mule.datasenseapi.api.ComponentResolutionScope;
import org.mule.datasenseapi.api.DataSenseInfo;
import org.mule.datasenseapi.api.DataSenseResolutionScope;
import org.mule.datasenseapi.api.metadataprovider.DataSenseMetadataCacheProvider;
import org.mule.datasenseapi.api.metadataprovider.DefaultExtensionsProvider;
import org.mule.datasenseapi.api.metadataprovider.ExtensionsProvider;
import org.mule.datasenseapi.api.notifications.DataSenseNotification;
import org.mule.datasenseapi.api.notifications.DataSenseNotificationType;
import org.mule.framework.api.tooling.type.propagation.TypePropagationRequest;
import org.mule.framework.api.tooling.type.propagation.TypePropagationResult;
import org.mule.framework.api.tooling.type.propagation.TypePropagationSession;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.tooling.type.propagation.DefaultTypePropagationResult;
import org.mule.framework.internal.tooling.type.propagation.legacy.DietToolingDataSenseMetadataProvider;
import org.mule.framework.internal.tooling.type.propagation.legacy.TypePropagationResolverUtils;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.apikit.metadata.api.MetadataService;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyDataSenseSession
implements TypePropagationSession {
    private static final String APP_TYPES_DATA = "application-types.xml";
    private static final String APP_TYPES_TEST_DATA = "application-types-test.xml";
    private static final Logger LOGGER = LoggerFactory.getLogger(LegacyDataSenseSession.class);
    private final ArtifactAst applicationModel;
    private final ClassLoader applicationClassLoader;
    private final ExpressionLanguageMetadataService expressionLanguageMetadataService;
    private final MetadataService apiKitMetadataService;
    private final InternalMuleFramework muleFramework;

    public LegacyDataSenseSession(ArtifactAst applicationModel, ClassLoader applicationClassLoader, ExpressionLanguageMetadataService expressionLanguageMetadataService, MetadataService metadataService, InternalMuleFramework muleFramework) {
        this.applicationModel = applicationModel;
        this.applicationClassLoader = applicationClassLoader;
        this.apiKitMetadataService = metadataService;
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
        this.muleFramework = muleFramework;
    }

    private Optional<ComponentAst> componentFromLocation(ComponentLocation location) {
        return this.applicationModel.recursiveStream().filter(comp -> comp.getLocation().equals(location)).findFirst();
    }

    public CompletableFuture<TypePropagationResult> resolveAndPropagateTypes(TypePropagationRequest request) {
        ComponentLocation location = request.propagationTarget();
        Optional<ComponentAst> componentAst = this.componentFromLocation(location);
        if (!componentAst.isPresent()) {
            return CompletableFuture.completedFuture(DefaultTypePropagationResult.failure(Collections.singletonList(I18nMessageFactory.createStaticMessage((String)String.format("Incorrect location: %s", location.getLocation())))));
        }
        HashMap<ComponentLocation, ConnectableComponentModel> updatedModels = new HashMap<ComponentLocation, ConnectableComponentModel>();
        Location loc = Location.builderFromStringRepresentation((String)location.getLocation()).build();
        Optional resolved = new DefaultDataSense().resolve((DataSenseResolutionScope)new ComponentResolutionScope(loc), this.buildDataSenseApplicationModel(), this.getDataSenseProvider((ExtensionsProvider)new DefaultExtensionsProvider(this.applicationModel.dependencies()), updatedModels, Optional.empty()));
        return CompletableFuture.completedFuture(resolved.map(dataSenseInfo -> this.isFailureResolution((DataSenseInfo)dataSenseInfo) ? DefaultTypePropagationResult.failure(this.errorMessages((DataSenseInfo)dataSenseInfo)) : TypePropagationResolverUtils.resolve((ComponentAst)componentAst.get(), dataSenseInfo, updatedModels, request.traceMetadataDefinitionLocation())).orElse(DefaultTypePropagationResult.failure(Collections.singletonList(I18nMessageFactory.createStaticMessage((String)"Resolution could not be performed correctly")))));
    }

    private boolean isFailureResolution(DataSenseInfo resolution) {
        return resolution.getDataSenseNotifications().stream().anyMatch(this::isErrorNotification);
    }

    private List<I18nMessage> errorMessages(DataSenseInfo resolution) {
        return resolution.getDataSenseNotifications().stream().filter(this::isErrorNotification).map(DataSenseNotification::getMessage).collect(Collectors.toList());
    }

    private boolean isErrorNotification(DataSenseNotification notification) {
        return notification.getNotificationType() == DataSenseNotificationType.ERROR || notification.getNotificationType() == DataSenseNotificationType.FATAL_ERROR;
    }

    private ApplicationModel buildDataSenseApplicationModel() {
        ArrayList<String> typesDataList = new ArrayList<String>();
        typesDataList.addAll(this.getApplicationTypes(APP_TYPES_DATA));
        typesDataList.addAll(this.getApplicationTypes(APP_TYPES_TEST_DATA));
        return new DefaultApplicationModel(this.applicationModel.getArtifactName(), this.applicationModel, typesDataList, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> getApplicationTypes(String resource) {
        ArrayList<String> applicationTypes = new ArrayList<String>();
        try {
            Enumeration<URL> resources = this.applicationClassLoader.getResources(resource);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Found application custom types data from: {}", (Object)url);
                }
                try {
                    applicationTypes.add(IOUtils.toString((URL)url));
                }
                catch (IOException e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Error while reading application custom types file: %s for %s", (Object[])new Object[]{url, this.applicationModel.getArtifactName()}), (Throwable)e);
                    return applicationTypes;
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private DataSenseProvider getDataSenseProvider(ExtensionsProvider extensionsProvider, Map<ComponentLocation, ConnectableComponentModel> updatedModels, Optional<DataSenseMetadataCacheProvider> dataSenseMetadataCacheProvider) {
        DefaultDataSenseProvider dataSenseProvider = new DefaultDataSenseProvider(extensionsProvider, (DataSenseMetadataProvider)new DietToolingDataSenseMetadataProvider(this.muleFramework, updatedModels), new DataSenseConfiguration(), this.expressionLanguageMetadataService, this.apiKitMetadataService.getApikitMetadataBuilder());
        if (dataSenseMetadataCacheProvider.isPresent()) {
            dataSenseProvider = new CachedDataSenseProvider(dataSenseMetadataCacheProvider.get(), (DataSenseProvider)dataSenseProvider);
        }
        return dataSenseProvider;
    }
}

