/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation.cfg;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.UnionTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.UnionType;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.meta.model.nested.ChainExecutionOccurrence;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;

public class VariablesTracker {
    private static final MetadataType ANY_TYPE = new BaseTypeBuilder(MetadataFormat.JAVA).anyType().build();
    private static final MetadataType NULL_TYPE = new BaseTypeBuilder(MetadataFormat.JAVA).nullType().build();
    private final Deque<Map<String, MetadataType>> lastVariables = new ArrayDeque<Map<String, MetadataType>>();

    public VariablesTracker() {
        this.lastVariables.push(new HashMap());
    }

    public void addVariablesPreChain(ChainExecutionPathTree operation, Map<String, MetadataType> addedVars) {
        HashMap<String, MetadataType> vars = new HashMap<String, MetadataType>(this.lastVariables.peek());
        vars.putAll(addedVars);
        this.lastVariables.push(vars);
    }

    public void combineVariables(ChainExecutionPathTree operation) {
        TypedComponentIdentifier.ComponentType componentType = operation.getComponentAst().getComponentType();
        if (componentType.equals((Object)TypedComponentIdentifier.ComponentType.SCOPE)) {
            this.combineVariablesForScope(operation);
        } else if (componentType.equals((Object)TypedComponentIdentifier.ComponentType.ROUTER)) {
            this.combineVariablesForRouter(operation);
        }
    }

    private void combineVariablesForScope(ChainExecutionPathTree scope) {
        Map<String, MetadataType> postChain = this.lastVariables.pop();
        Map<String, MetadataType> preChain = this.lastVariables.peek();
        HashMap addedVars = new HashMap();
        postChain.forEach((name, type) -> {
            if (type.equals(preChain.get(name))) {
                return;
            }
            ArrayType finalType = new BaseTypeBuilder(MetadataFormat.JAVA).arrayType().of(type).build();
            if (preChain.containsKey(name)) {
                finalType = VariablesTracker.unionOf((MetadataType)finalType, (MetadataType)preChain.get(name));
            }
            addedVars.put(name, finalType);
        });
        HashMap<String, MetadataType> vars = new HashMap<String, MetadataType>(preChain);
        vars.putAll(addedVars);
        this.lastVariables.push(vars);
    }

    private void combineVariablesForRouter(ChainExecutionPathTree router) {
        Map<String, MetadataType> preRoutesVariables = this.lastVariables.pop();
        ArrayList<Pair<Map<String, MetadataType>, ChainExecutionOccurrence>> routesVariables = new ArrayList<Pair<Map<String, MetadataType>, ChainExecutionOccurrence>>();
        for (int i = 0; i < router.children().size(); ++i) {
            NestedChainModel routeModel = (NestedChainModel)((NestedRouteModel)((ChainExecutionPathTree)router.children().get(i)).getComponentAst().getModel(NestedRouteModel.class).get()).getNestedComponents().get(0);
            routesVariables.add((Pair<Map<String, MetadataType>, ChainExecutionOccurrence>)new Pair(this.lastVariables.pop(), (Object)routeModel.getChainExecutionOccurrence()));
        }
        this.doCombineRouterVariables(preRoutesVariables, routesVariables);
    }

    private void doCombineRouterVariables(Map<String, MetadataType> preChainsVariables, List<Pair<Map<String, MetadataType>, ChainExecutionOccurrence>> chainsVariables) {
        HashMap<String, MetadataType> addedVars = new HashMap<String, MetadataType>();
        HashSet<String> alwaysHaveValueSet = new HashSet<String>(preChainsVariables.keySet());
        HashMap presencePotentiallyExecuted = new HashMap();
        chainsVariables.forEach(chainVars -> ((Map)chainVars.getFirst()).forEach((name, type) -> {
            if (preChainsVariables.containsKey(name) && ((MetadataType)preChainsVariables.get(name)).equals(type)) {
                return;
            }
            if (this.chainMayNotBeExecuted((ChainExecutionOccurrence)chainVars.getSecond())) {
                presencePotentiallyExecuted.put(name, presencePotentiallyExecuted.getOrDefault(name, 0) + 1);
            } else {
                alwaysHaveValueSet.add((String)name);
            }
            if (!addedVars.containsKey(name)) {
                addedVars.put((String)name, (MetadataType)type);
                return;
            }
            if (((MetadataType)addedVars.get(name)).equals(type)) {
                if (!((ChainExecutionOccurrence)chainVars.getSecond()).equals((Object)ChainExecutionOccurrence.ONCE_OR_NONE)) {
                    addedVars.put((String)name, (MetadataType)new BaseTypeBuilder(MetadataFormat.JAVA).arrayType().of(type).build());
                }
            } else if (addedVars.get(name) instanceof ArrayType) {
                ArrayType arrType = (ArrayType)addedVars.get(name);
                if (!arrType.getType().equals(type)) {
                    addedVars.put((String)name, (MetadataType)new BaseTypeBuilder(MetadataFormat.JAVA).arrayType().of(ANY_TYPE).build());
                }
            } else if (((ChainExecutionOccurrence)chainVars.getSecond()).equals((Object)ChainExecutionOccurrence.ONCE_OR_NONE)) {
                addedVars.put((String)name, VariablesTracker.unionOf((MetadataType)addedVars.get(name), type));
            } else {
                addedVars.put((String)name, (MetadataType)new BaseTypeBuilder(MetadataFormat.JAVA).arrayType().of(ANY_TYPE).build());
            }
        }));
        for (String name : addedVars.keySet()) {
            if (alwaysHaveValueSet.contains(name) || ((Integer)presencePotentiallyExecuted.get(name)).intValue() == chainsVariables.size()) continue;
            addedVars.put(name, VariablesTracker.unionOf((MetadataType)addedVars.get(name), NULL_TYPE));
        }
        HashMap<String, MetadataType> vars = new HashMap<String, MetadataType>(preChainsVariables);
        vars.putAll(addedVars);
        this.lastVariables.push(vars);
    }

    private boolean chainMayNotBeExecuted(ChainExecutionOccurrence occurrence) {
        return occurrence.equals((Object)ChainExecutionOccurrence.ONCE_OR_NONE) || occurrence.equals((Object)ChainExecutionOccurrence.MULTIPLE_OR_NONE);
    }

    public void saveCurrentVariables() {
        this.lastVariables.push(this.lastVariables.peek());
    }

    public void backtrackToPreRouteState() {
        Map<String, MetadataType> routeVars = this.lastVariables.pop();
        Map<String, MetadataType> preRouterVars = this.lastVariables.pop();
        this.lastVariables.push(routeVars);
        this.lastVariables.push(preRouterVars);
    }

    public Map<String, MetadataType> getCurrentVariables() {
        return this.lastVariables.peek();
    }

    public void setCurrentVariables(Map<String, MetadataType> newVars) {
        this.lastVariables.pop();
        this.lastVariables.push(newVars);
    }

    public void addVariable(String name, MetadataType type) {
        HashMap<String, MetadataType> newVars = new HashMap<String, MetadataType>(this.getCurrentVariables());
        newVars.put(name, type);
        this.setCurrentVariables(newVars);
    }

    public void goBackToPreviousVariables() {
        this.lastVariables.pop();
    }

    public void removeVariable(String name) {
        HashMap<String, MetadataType> vars = new HashMap<String, MetadataType>(this.getCurrentVariables());
        vars.remove(name);
        this.setCurrentVariables(vars);
    }

    private static MetadataType unionOf(MetadataType a, MetadataType b) {
        if (a.equals(b)) {
            return a;
        }
        UnionTypeBuilder builder = new BaseTypeBuilder(MetadataFormat.JAVA).unionType().flattens().removesRepetitions();
        builder.of(a);
        builder.of(b);
        UnionType result = builder.build();
        if (result.getTypes().size() > 1) {
            return result;
        }
        return (MetadataType)result.getTypes().get(0);
    }
}

