/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation.cfg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.framework.api.extension.config.ConfigurationHandler;
import org.mule.framework.api.tooling.MuleToolingFramework;
import org.mule.framework.api.tooling.type.resolution.TypeResolutionContext;
import org.mule.framework.api.tooling.type.resolution.TypeResolutionSession;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.tooling.type.propagation.cfg.CFGRouterMetadataContext;
import org.mule.framework.internal.tooling.type.propagation.cfg.CFGScopeMetadataContext;
import org.mule.framework.internal.tooling.type.propagation.cfg.CFGTypeResolutionContext;
import org.mule.framework.internal.tooling.type.propagation.cfg.MessageTracker;
import org.mule.framework.internal.tooling.type.propagation.cfg.VariablesTracker;
import org.mule.framework.internal.tooling.type.propagation.utils.CoreUtils;
import org.mule.framework.internal.tooling.type.propagation.utils.ModelsUtils;
import org.mule.framework.internal.tooling.type.resolution.NullTypeResolutionContext;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataTypesDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.cfg.api.BaseChainExecutionPathTreeVisitor;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.module.extension.internal.runtime.resolver.ComponentParameterizationUtils;

public class TypePropagationCFGVisitor
extends BaseChainExecutionPathTreeVisitor {
    private static final String CONFIG_ATTRIBUTE_NAME = "config-ref";
    private static final String TARGET_ATTRIBUTE_NAME = "target";
    private static final String TARGET_VALUE_ATTRIBUTE_NAME = "targetValue";
    private static final MetadataType ANY_TYPE = new BaseTypeBuilder(MetadataFormat.JAVA).anyType().build();
    private final Map<ComponentLocation, MetadataResult<HasOutputModel>> outputs = new HashMap<ComponentLocation, MetadataResult<HasOutputModel>>();
    private final Map<ComponentLocation, Pair<MetadataType, MetadataType>> chainOutputs = new HashMap<ComponentLocation, Pair<MetadataType, MetadataType>>();
    private final Map<ComponentLocation, MessageMetadataType> inputs = new HashMap<ComponentLocation, MessageMetadataType>();
    private final Map<ComponentLocation, Map<String, MetadataType>> variables = new HashMap<ComponentLocation, Map<String, MetadataType>>();
    private final InternalMuleFramework framework;
    private final MuleToolingFramework toolingFramework;
    private final ExpressionLanguageMetadataService expressionLanguageMetadataService;
    private final Map<ComponentLocation, ConnectableComponentModel> updatedModels = new HashMap<ComponentLocation, ConnectableComponentModel>();
    private final MessageTracker messageTracker = new MessageTracker((MetadataType)new BaseTypeBuilder(MetadataFormat.JAVA).anyType().build(), (MetadataType)new BaseTypeBuilder(MetadataFormat.JAVA).voidType().build());
    private final VariablesTracker variablesTracker = new VariablesTracker();
    private final Set<ComponentLocation> manuallyTraversed = new HashSet<ComponentLocation>();
    private ComponentLocation propagationTarget;
    private boolean success = true;
    private boolean skipSource = false;

    public TypePropagationCFGVisitor(InternalMuleFramework framework, ExpressionLanguageMetadataService expressionLanguageMetadataService, ComponentLocation propagationTarget) {
        this.framework = framework;
        this.toolingFramework = framework.getToolingFramework();
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
        this.propagationTarget = propagationTarget;
    }

    public void initialMessage(MessageMetadataType message) {
        this.skipSource = true;
        this.messageTracker.setMessageTypes(message);
    }

    public void initialPayload(MetadataType payload) {
        this.skipSource = true;
        this.messageTracker.setPayload(payload);
    }

    public void initialAttributes(MetadataType payload) {
        this.messageTracker.setAttributes(payload);
    }

    public void visitSource(ChainExecutionPathTree source) {
        if (this.skipSource) {
            return;
        }
        ComponentAst sourceAst = source.getComponentAst();
        Optional model = sourceAst.getModel(SourceModel.class);
        ComponentLocation sourceLocation = sourceAst.getLocation();
        if (!model.isPresent()) {
            this.outputs.put(sourceLocation, (MetadataResult<HasOutputModel>)MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(String.format("Component at location %s has no SourceModel", sourceAst.getLocation().getLocation())).withFailureCode(FailureCode.NO_DYNAMIC_METADATA_AVAILABLE).onComponent()}));
            this.success = false;
            return;
        }
        try (TypeResolutionSession resolutionSession = this.toolingFramework.createTypeResolutionSession(sourceAst.getExtensionModel().getName(), (ComponentModel)model.get());){
            Map<String, Object> params = this.getParameters(sourceAst, Optional.of(((SourceModel)model.get()).getParameterGroupModels().stream().map(NamedObject::getName).collect(Collectors.toSet())));
            ComponentParameterization parameterization = ComponentParameterizationUtils.createComponentParameterization((ParameterizedModel)((ParameterizedModel)model.get()), params);
            Optional<ConfigurationHandler> handler = this.getConfigurationHandler(sourceAst, params);
            MetadataResult result = resolutionSession.resolveComponentTypes(parameterization, handler, NullTypeResolutionContext.getInstance());
            if (result.isSuccess()) {
                SourceModel updatedModel = ModelsUtils.getTypedSourceModel((SourceModel)model.get(), ((ComponentMetadataTypesDescriptor)result.get()).getInputMetadata(), ((ComponentMetadataTypesDescriptor)result.get()).getOutputMetadata(), ((ComponentMetadataTypesDescriptor)result.get()).getOutputAttributesMetadata());
                this.outputs.put(sourceLocation, (MetadataResult<HasOutputModel>)MetadataResult.success((Object)updatedModel));
                this.updatedModels.put(sourceLocation, (ConnectableComponentModel)updatedModel);
                this.messageTracker.setMessageTypes(updatedModel.getOutput().getType(), updatedModel.getOutputAttributes().getType());
                this.variables.put(sourceLocation, this.variablesTracker.getCurrentVariables());
            } else {
                this.outputs.put(sourceLocation, (MetadataResult<HasOutputModel>)MetadataResult.failure((List)result.getFailures()));
                this.success = false;
            }
        }
        catch (Exception e) {
            this.outputs.put(sourceLocation, (MetadataResult<HasOutputModel>)MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onComponent()}));
            this.success = false;
        }
    }

    public void visitSimpleOperation(ChainExecutionPathTree operation) {
        if (CoreUtils.requiresSpecialHandling(operation.getComponentAst().getIdentifier())) {
            this.resolveSpecialCases(operation);
        } else {
            this.visitAllOperations(operation, NullTypeResolutionContext.getInstance());
        }
    }

    public void visitReferencedOperation(ChainExecutionPathTree operation) {
        this.inputs.put(operation.getComponentAst().getLocation(), this.messageTracker.getFullMessageType());
        Map<String, Object> params = this.getParameters(operation.getComponentAst());
        if (params.containsKey(TARGET_ATTRIBUTE_NAME)) {
            this.setSpecialCasesOutputs(operation.getComponentAst(), this.messageTracker.getCurrentPayload(), Optional.ofNullable(this.messageTracker.getCurrentAttributes()));
        }
    }

    public void finishReferencedOperation(ChainExecutionPathTree operation) {
        Map<String, Object> params = this.getParameters(operation.getComponentAst());
        MetadataType output = this.targetValue(operation, params, this.messageTracker.getCurrentPayload(), this.messageTracker.getCurrentAttributes());
        if (params.containsKey(TARGET_ATTRIBUTE_NAME)) {
            String variable = (String)params.get(TARGET_ATTRIBUTE_NAME);
            this.variablesTracker.addVariable(variable, output);
            this.messageTracker.setPayload(((HasOutputModel)this.outputs.get(operation.getComponentAst().getLocation()).get()).getOutput().getType());
        } else {
            this.messageTracker.setPayload(output);
            this.setSpecialCasesOutputs(operation.getComponentAst(), output, Optional.ofNullable(this.messageTracker.getCurrentAttributes()));
        }
    }

    private boolean shouldPropagateThroughInnerChain(ComponentLocation container) {
        if (this.outputs.containsKey(container)) {
            return false;
        }
        if (this.outputs.containsKey(this.propagationTarget)) {
            return false;
        }
        if (this.isMinimizedPropagation()) {
            return this.propagationTarget.getLocation().startsWith(container.getLocation());
        }
        return true;
    }

    public boolean visitScope(ChainExecutionPathTree scope) {
        CFGScopeMetadataContext scopeMetadataContext = new CFGScopeMetadataContext(scope, this, this.messageTracker.getCurrentPayload(), this.messageTracker.getCurrentAttributes());
        MetadataType defaultOutput = this.messageTracker.getCurrentPayload();
        MetadataType defaultOutputAttr = this.messageTracker.getCurrentAttributes();
        this.variablesPreChain(scope);
        if (this.messagePreVisitChain(scope)) {
            this.visitAllOperations(scope, new CFGTypeResolutionContext(scopeMetadataContext), () -> defaultOutput, () -> defaultOutputAttr);
        }
        if (scope.anyExecutionPathContains(pathTree -> this.shouldPropagateThroughInnerChain(pathTree.getComponentAst().getLocation()))) {
            this.manuallyTraversed.add(scope.getComponentAst().getLocation());
            this.messageTracker.revertCurrentState();
            return true;
        }
        return false;
    }

    public void scopeFinished(ChainExecutionPathTree scope) {
        this.chainOutputs.put(scope.getComponentAst().getLocation(), (Pair<MetadataType, MetadataType>)new Pair((Object)this.messageTracker.getCurrentPayload(), (Object)this.messageTracker.getCurrentAttributes()));
        this.variablesPostChain(scope);
        this.messagePostVisitChain(scope);
    }

    public boolean visitRouter(ChainExecutionPathTree router) {
        CFGRouterMetadataContext routerMetadataContext = new CFGRouterMetadataContext(router, this, this.messageTracker.getCurrentPayload(), this.messageTracker.getCurrentAttributes());
        this.variablesPreChain(router);
        this.visitAllOperations(router, new CFGTypeResolutionContext(routerMetadataContext));
        return router.anyExecutionPathContains(pathTree -> this.shouldPropagateThroughInnerChain(pathTree.getComponentAst().getLocation()));
    }

    public boolean innerRouteStarted(ChainExecutionPathTree innerChain) {
        if (this.shouldPropagateThroughInnerChain(innerChain.getComponentAst().getLocation())) {
            this.messageTracker.saveCurrentState();
            this.variablesTracker.saveCurrentVariables();
            return true;
        }
        return false;
    }

    public void innerRouteFinished(ChainExecutionPathTree innerChain) {
        this.outputs.put(innerChain.getComponentAst().getLocation(), null);
        this.chainOutputs.put(innerChain.getComponentAst().getLocation(), (Pair<MetadataType, MetadataType>)new Pair((Object)this.messageTracker.getCurrentPayload(), (Object)this.messageTracker.getCurrentAttributes()));
        this.variablesTracker.backtrackToPreRouteState();
        this.messageTracker.revertCurrentState();
    }

    public Pair<MetadataType, MetadataType> getChainResult(ChainExecutionPathTree chain) {
        return this.chainOutputs.get(chain.getComponentAst().getLocation());
    }

    public void routerFinished(ChainExecutionPathTree router) {
        this.variablesPostChain(router);
    }

    private Map<String, Object> getParameters(ComponentAst componentModelAst) {
        return this.getParameters(componentModelAst, Optional.empty());
    }

    private Map<String, Object> getParameters(ComponentAst componentModelAst, Optional<Set<String>> parameterGroups) {
        Map<String, Object> withResolvedValues = componentModelAst.getParameters().stream().filter(param -> param.getValue().isRight()).filter(param -> parameterGroups.map(pg -> pg.contains(param.getGroupModel().getName())).orElse(true)).collect(Collectors.toMap(param -> param.getModel().getName(), param -> param.getValue().getRight()));
        Map<String, Object> withRawValues = componentModelAst.getParameters().stream().filter(param -> !param.getValue().isRight()).filter(param -> param.getRawValue() != null).filter(param -> parameterGroups.map(pg -> pg.contains(param.getGroupModel().getName())).orElse(true)).collect(Collectors.toMap(param -> param.getModel().getName(), ComponentParameterAst::getRawValue, (v1, v2) -> v1));
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(withResolvedValues);
        result.putAll(withRawValues);
        return result;
    }

    private Optional<ConfigurationHandler> getConfigurationHandler(ComponentAst componentAst, Map<String, Object> params) {
        return componentAst.getModel(ComponentModel.class).flatMap(model -> params.containsKey(CONFIG_ATTRIBUTE_NAME) ? this.framework.getConfigurationHandler((String)params.get(CONFIG_ATTRIBUTE_NAME)) : Optional.empty());
    }

    public MetadataResult<HasOutputModel> getResult(ComponentLocation location) {
        return this.outputs.get(location);
    }

    public MetadataType getLastMetadataType() {
        return this.messageTracker.getCurrentPayload();
    }

    public MetadataType getLastAttributesType() {
        return this.messageTracker.getCurrentAttributes();
    }

    public Map<String, MetadataType> getLastVariables() {
        return this.variablesTracker.getCurrentVariables();
    }

    public Optional<MessageMetadataType> getInput(ComponentLocation location) {
        return Optional.ofNullable(this.inputs.getOrDefault(location, null));
    }

    public Map<String, MetadataType> getInputVariables(ComponentLocation location) {
        return this.variables.getOrDefault(location, Collections.emptyMap());
    }

    private void visitAllOperations(ChainExecutionPathTree operation, TypeResolutionContext resolutionContext) {
        this.visitAllOperations(operation, resolutionContext, this.messageTracker::getCurrentPayload, this.messageTracker::getCurrentAttributes);
    }

    private void visitAllOperations(ChainExecutionPathTree operation, TypeResolutionContext resolutionContext, Supplier<MetadataType> defaultOutput, Supplier<MetadataType> defaultOutputAttributes) {
        ComponentAst operationAst = operation.getComponentAst();
        Optional model = operationAst.getModel(OperationModel.class);
        this.inputs.put(operationAst.getLocation(), this.messageTracker.getFullMessageType());
        if (!model.isPresent()) {
            if (operationAst.getComponentType() == TypedComponentIdentifier.ComponentType.SCOPE || operationAst.getComponentType() == TypedComponentIdentifier.ComponentType.ROUTER) {
                this.setSpecialCasesOutputs(operationAst, ANY_TYPE, Optional.empty());
            } else {
                this.outputs.put(operationAst.getLocation(), (MetadataResult<HasOutputModel>)MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(String.format("Component in %s has no OperationModel", operationAst.getLocation().getLocation())).withFailureCode(FailureCode.NO_DYNAMIC_METADATA_AVAILABLE).onComponent()}));
                this.success = false;
            }
            return;
        }
        try (TypeResolutionSession resolutionSession = this.toolingFramework.createTypeResolutionSession(operationAst.getExtensionModel().getName(), (ComponentModel)model.get());){
            Map<String, Object> params = this.getParameters(operationAst);
            ComponentParameterization parameterization = ComponentParameterizationUtils.createComponentParameterization((ParameterizedModel)((ParameterizedModel)model.get()), params);
            Optional<ConfigurationHandler> handler = this.getConfigurationHandler(operationAst, params);
            MetadataResult result = resolutionSession.resolveComponentTypes(parameterization, handler, resolutionContext);
            if (result.isSuccess()) {
                MetadataType output = ((ComponentMetadataTypesDescriptor)result.get()).getOutputMetadata().filter(metadata -> !(metadata instanceof VoidType)).orElseGet(defaultOutput);
                MetadataType outputAttr = ((ComponentMetadataTypesDescriptor)result.get()).getOutputAttributesMetadata().filter(metadata -> !(metadata instanceof VoidType)).orElseGet(defaultOutputAttributes);
                output = this.targetValue(operation, params, output, outputAttr);
                OperationModel updatedModel = ModelsUtils.getTypedOperationModel((OperationModel)model.get(), ((ComponentMetadataTypesDescriptor)result.get()).getInputMetadata(), Optional.ofNullable(output), Optional.ofNullable(outputAttr));
                if (output != null) {
                    this.outputs.put(operationAst.getLocation(), (MetadataResult<HasOutputModel>)MetadataResult.success((Object)updatedModel));
                }
                this.setOutputToCorrectVariable(params, output);
                this.messageTracker.setAttributes(updatedModel.getOutputAttributes().getType());
                this.updatedModels.put(operationAst.getLocation(), (ConnectableComponentModel)updatedModel);
                this.variables.put(operationAst.getLocation(), Collections.unmodifiableMap(this.variablesTracker.getCurrentVariables()));
            } else {
                this.outputs.put(operationAst.getLocation(), (MetadataResult<HasOutputModel>)MetadataResult.failure((List)result.getFailures()));
                this.success = false;
            }
        }
        catch (Exception e) {
            this.outputs.put(operationAst.getLocation(), (MetadataResult<HasOutputModel>)MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onComponent()}));
            this.success = false;
        }
    }

    private MetadataType targetValue(ChainExecutionPathTree operation, Map<String, Object> params, MetadataType originalOutput, MetadataType attributes) {
        if (!params.containsKey(TARGET_VALUE_ATTRIBUTE_NAME)) {
            return originalOutput;
        }
        String expression = this.cleanExpression((String)params.get(TARGET_VALUE_ATTRIBUTE_NAME));
        ArrayList<String> errorsFound = new ArrayList<String>();
        TypeBindings bindings = this.getBindings(originalOutput, attributes, this.variablesTracker.getCurrentVariables());
        MetadataType output = this.expressionLanguageMetadataService.getOutputType(bindings, expression, this.createMessageCallback(errorsFound));
        if (errorsFound.isEmpty()) {
            return output;
        }
        this.outputs.put(operation.getComponentAst().getLocation(), (MetadataResult<HasOutputModel>)MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(String.join((CharSequence)"; ", (CharSequence)errorsFound.get(0))).withFailureCode(FailureCode.NO_DYNAMIC_METADATA_AVAILABLE).onComponent()}));
        this.success = false;
        return null;
    }

    private void setOutputToCorrectVariable(Map<String, Object> params, MetadataType output) {
        if (output == null) {
            return;
        }
        if (params.containsKey(TARGET_ATTRIBUTE_NAME)) {
            String variable = (String)params.get(TARGET_ATTRIBUTE_NAME);
            this.variablesTracker.addVariable(variable, output);
        } else {
            this.messageTracker.setPayload(output);
        }
    }

    private void resolveSpecialCases(ChainExecutionPathTree operation) {
        this.inputs.put(operation.getComponentAst().getLocation(), this.messageTracker.getFullMessageType());
        ComponentIdentifier identifier = operation.getComponentAst().getIdentifier();
        if (identifier.equals(CoreUtils.SET_PAYLOAD_IDENTIFIER)) {
            this.resolveSetPayload(operation);
        } else if (identifier.equals(CoreUtils.SET_VARIABLE_IDENTIFIER)) {
            this.resolveSetVariable(operation);
        } else if (identifier.equals(CoreUtils.REMOVE_VARIABLE_IDENTIFIER)) {
            this.resolveRemoveVariable(operation);
        } else if (identifier.equals(CoreUtils.EE_TRANSFORM_IDENTIFIER)) {
            this.resolveEeTransform(operation);
        } else if (identifier.equals(CoreUtils.LOGGER_IDENTIFIER)) {
            this.setSpecialCasesOutputs(operation.getComponentAst(), this.messageTracker.getCurrentPayload(), Optional.ofNullable(this.messageTracker.getCurrentAttributes()));
        }
    }

    private void resolveSetPayload(ChainExecutionPathTree operation) {
        Map<String, Object> params = this.getParameters(operation.getComponentAst());
        TypeBindings bindings = this.getBindings(this.messageTracker.getCurrentPayload(), this.messageTracker.getCurrentAttributes(), this.variablesTracker.getCurrentVariables());
        String expression = this.cleanExpression((String)params.get("value"));
        ArrayList<String> errorsFound = new ArrayList<String>();
        MetadataType output = this.expressionLanguageMetadataService.getOutputType(bindings, expression, this.createMessageCallback(errorsFound));
        if (errorsFound.isEmpty()) {
            this.messageTracker.setPayload(output);
            this.setSpecialCasesOutputs(operation.getComponentAst(), output, Optional.ofNullable(this.messageTracker.getCurrentAttributes()));
        } else {
            this.outputs.put(operation.getComponentAst().getLocation(), (MetadataResult<HasOutputModel>)MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(String.join((CharSequence)"; ", (CharSequence)errorsFound.get(0))).withFailureCode(FailureCode.NO_DYNAMIC_METADATA_AVAILABLE).onComponent()}));
            this.success = false;
        }
    }

    private void resolveSetVariable(ChainExecutionPathTree operation) {
        Map<String, Object> params = this.getParameters(operation.getComponentAst());
        Map<String, MetadataType> currentVariables = this.variablesTracker.getCurrentVariables();
        this.variables.put(operation.getComponentAst().getLocation(), currentVariables);
        TypeBindings bindings = this.getBindings(this.messageTracker.getCurrentPayload(), this.messageTracker.getCurrentAttributes(), currentVariables);
        String expression = this.cleanExpression((String)params.get("value"));
        String name = (String)params.get("variableName");
        ArrayList<String> errorsFound = new ArrayList<String>();
        MetadataType resolvedValue = this.expressionLanguageMetadataService.getOutputType(bindings, expression, this.createMessageCallback(errorsFound));
        if (errorsFound.isEmpty()) {
            this.setSpecialCasesOutputs(operation.getComponentAst(), this.messageTracker.getCurrentPayload(), Optional.ofNullable(this.messageTracker.getCurrentAttributes()));
            this.variablesTracker.addVariable(name, resolvedValue);
        } else {
            this.outputs.put(operation.getComponentAst().getLocation(), (MetadataResult<HasOutputModel>)MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(String.join((CharSequence)"; ", (CharSequence)errorsFound.get(0))).withFailureCode(FailureCode.NO_DYNAMIC_METADATA_AVAILABLE).onComponent()}));
            this.success = false;
        }
    }

    private void resolveRemoveVariable(ChainExecutionPathTree operation) {
        Map<String, Object> params = this.getParameters(operation.getComponentAst());
        this.variables.put(operation.getComponentAst().getLocation(), this.variablesTracker.getCurrentVariables());
        String name = (String)params.get("variableName");
        this.variablesTracker.removeVariable(name);
        this.setSpecialCasesOutputs(operation.getComponentAst(), this.messageTracker.getCurrentPayload(), Optional.ofNullable(this.messageTracker.getCurrentAttributes()));
    }

    private void resolveEeTransform(ChainExecutionPathTree operation) {
        String attrExpression;
        String payloadExpression;
        Map<String, Object> params = this.getParameters(operation.getComponentAst());
        TypeBindings bindings = this.getBindings(this.messageTracker.getCurrentPayload(), this.messageTracker.getCurrentAttributes(), this.variablesTracker.getCurrentVariables());
        ArrayList<String> errorsFound = new ArrayList<String>();
        if (params.containsKey("setPayload") && (payloadExpression = (String)this.getParameters((ComponentAst)params.get("setPayload")).getOrDefault("script", null)) != null) {
            this.messageTracker.setPayload(this.expressionLanguageMetadataService.getOutputType(bindings, payloadExpression, this.createMessageCallback(errorsFound)));
        }
        if (params.containsKey("setAttributes") && (attrExpression = (String)this.getParameters((ComponentAst)params.get("setAttributes")).getOrDefault("script", null)) != null) {
            this.messageTracker.setAttributes(this.expressionLanguageMetadataService.getOutputType(bindings, attrExpression, this.createMessageCallback(errorsFound)));
        }
        if (params.containsKey("variables")) {
            ArrayList vars = (ArrayList)params.get("variables");
            vars.forEach(varModAst -> {
                Map<String, Object> varParams = this.getParameters((ComponentAst)varModAst);
                String varName = (String)varParams.get("variableName");
                String varExpression = (String)varParams.get("script");
                this.variablesTracker.addVariable(varName, this.expressionLanguageMetadataService.getOutputType(bindings, varExpression, this.createMessageCallback(errorsFound)));
            });
        }
        if (errorsFound.isEmpty()) {
            this.setSpecialCasesOutputs(operation.getComponentAst(), this.messageTracker.getCurrentPayload(), Optional.ofNullable(this.messageTracker.getCurrentAttributes()));
        } else {
            this.outputs.put(operation.getComponentAst().getLocation(), (MetadataResult<HasOutputModel>)MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(String.join((CharSequence)"; ", (CharSequence)errorsFound.get(0))).withFailureCode(FailureCode.NO_DYNAMIC_METADATA_AVAILABLE).onComponent()}));
            this.success = false;
        }
    }

    private void setSpecialCasesOutputs(ComponentAst operationAst, MetadataType metadataType, Optional<MetadataType> attributes) {
        OperationModel specialCaseModel = (OperationModel)operationAst.getModel(OperationModel.class).get();
        OperationModel updatedModel = ModelsUtils.getTypedOperationModel(specialCaseModel, Collections.emptyMap(), Optional.ofNullable(metadataType), attributes);
        this.outputs.put(operationAst.getLocation(), (MetadataResult<HasOutputModel>)MetadataResult.success((Object)updatedModel));
        this.variables.put(operationAst.getLocation(), Collections.unmodifiableMap(this.variablesTracker.getCurrentVariables()));
    }

    private TypeBindings getBindings(MetadataType payload, MetadataType attributes, Map<String, MetadataType> vars) {
        MuleEventMetadataTypeBuilder typeBuilder = new MuleEventMetadataTypeBuilder();
        vars.forEach((arg_0, arg_1) -> ((MuleEventMetadataTypeBuilder)typeBuilder).addVariable(arg_0, arg_1));
        typeBuilder.message().payload(payload).attributes(attributes);
        return TypeBindings.builder((MuleEventMetadataType)typeBuilder.build()).build();
    }

    private String cleanExpression(String org) {
        if ((org = this.cleanFromProperties(org)).startsWith("#[") && org.endsWith("]")) {
            return org.substring(2, org.length() - 1);
        }
        if (org.startsWith("'") && org.endsWith("'")) {
            return org;
        }
        return "'" + org + "'";
    }

    private String cleanFromProperties(String org) {
        if (!org.contains("${")) {
            return org;
        }
        int startIndex = org.indexOf("${");
        int endIndex = org.indexOf("}", startIndex);
        return this.cleanFromProperties(org.substring(0, startIndex) + "'property'" + org.substring(endIndex + 1));
    }

    void setPropagationTarget(ComponentLocation target) {
        this.propagationTarget = target;
    }

    private void variablesPreChain(ChainExecutionPathTree operation) {
        ComponentIdentifier identifier = operation.getComponentAst().getIdentifier();
        if (identifier.equals(CoreUtils.FOREACH_IDENTIFIER)) {
            HashMap<String, MetadataType> addedVariables = new HashMap<String, MetadataType>();
            addedVariables.put(operation.getComponentAst().getParameter("General", "counterVariableName").getValue().getRight().toString(), (MetadataType)new BaseTypeBuilder(MetadataFormat.JAVA).numberType().build());
            addedVariables.put(operation.getComponentAst().getParameter("General", "rootMessageVariableName").getValue().getRight().toString(), (MetadataType)this.messageTracker.getFullMessageType());
            this.variablesTracker.addVariablesPreChain(operation, addedVariables);
        } else {
            this.variablesTracker.saveCurrentVariables();
        }
    }

    private void variablesPostChain(ChainExecutionPathTree operation) {
        ComponentIdentifier identifier = operation.getComponentAst().getIdentifier();
        if (CoreUtils.isCombinableVariablesIdentifier(identifier)) {
            this.variablesTracker.combineVariables(operation);
        } else if (!CoreUtils.belongsToMule(identifier) || identifier.equals(CoreUtils.ASYNC_IDENTIFIER)) {
            this.variablesTracker.goBackToPreviousVariables();
        }
        if (identifier.equals(CoreUtils.FOREACH_IDENTIFIER)) {
            this.variablesTracker.removeVariable(operation.getComponentAst().getParameter("General", "counterVariableName").getValue().getRight().toString());
            this.variablesTracker.removeVariable(operation.getComponentAst().getParameter("General", "rootMessageVariableName").getValue().getRight().toString());
        }
    }

    private boolean messagePreVisitChain(ChainExecutionPathTree operation) {
        ComponentIdentifier identifier = operation.getComponentAst().getIdentifier();
        if (identifier.equals(CoreUtils.FOREACH_IDENTIFIER) || identifier.equals(CoreUtils.PARALLEL_FOREACH_IDENTIFIER)) {
            this.messageTracker.saveCurrentState();
            Either collectionExpression = operation.getComponentAst().getParameter("General", "collection").getValue();
            MetadataType innerType = this.resolveCollectionType((String)collectionExpression.reduce(value -> value, value -> this.cleanExpression(value.toString())), operation.getComponentAst().getLocation());
            if (innerType == null) {
                return false;
            }
            this.messageTracker.setPayload(innerType);
            if (identifier.equals(CoreUtils.FOREACH_IDENTIFIER)) {
                this.messageTracker.saveCurrentState();
            }
        } else if (identifier.equals(CoreUtils.ASYNC_IDENTIFIER)) {
            this.messageTracker.saveCurrentState();
        } else if (identifier.equals(CoreUtils.BATCH_JOB_IDENTIFIER)) {
            this.messageTracker.saveCurrentState();
            MetadataType innerType = this.resolveCollectionType("payload", operation.getComponentAst().getLocation());
            if (innerType == null) {
                return false;
            }
            this.messageTracker.setPayload(innerType);
            this.messageTracker.setAttributes((MetadataType)new BaseTypeBuilder(MetadataFormat.JAVA).voidType().build());
            this.messageTracker.saveCurrentState();
        } else if (identifier.equals(CoreUtils.BATCH_AGGREGATOR_IDENTIFIER)) {
            this.messageTracker.setPayload((MetadataType)new BaseTypeBuilder(MetadataFormat.JAVA).arrayType().of(this.messageTracker.getCurrentPayload()).build());
            this.messageTracker.saveCurrentState();
        } else if (identifier.equals(CoreUtils.BATCH_ON_COMPLETE_IDENTIFIER)) {
            this.messageTracker.setPayload(CoreUtils.batchResultInput());
            this.messageTracker.saveCurrentState();
            return false;
        }
        return true;
    }

    private MetadataType resolveCollectionType(String expression, ComponentLocation opLocation) {
        TypeBindings bindings = this.getBindings(this.messageTracker.getCurrentPayload(), this.messageTracker.getCurrentAttributes(), this.variablesTracker.getCurrentVariables());
        ArrayList<String> errorsFound = new ArrayList<String>();
        MetadataType arrayType = this.expressionLanguageMetadataService.getOutputType(bindings, expression, this.createMessageCallback(errorsFound));
        if (errorsFound.isEmpty() && arrayType instanceof ArrayType) {
            return ((ArrayType)arrayType).getType();
        }
        this.outputs.put(opLocation, (MetadataResult<HasOutputModel>)MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(String.format("Collection Expression (%s) at location %s does not resolve to a collection", expression, opLocation.getLocation())).withFailureCode(FailureCode.NO_DYNAMIC_METADATA_AVAILABLE).onComponent()}));
        this.success = false;
        return null;
    }

    private void messagePostVisitChain(ChainExecutionPathTree operation) {
        if (this.manuallyTraversed.contains(operation.getComponentAst().getLocation())) {
            MetadataResult<HasOutputModel> output = this.outputs.get(operation.getComponentAst().getLocation());
            if (output != null && output.isSuccess()) {
                this.messageTracker.setPayload(((HasOutputModel)output.get()).getOutput().getType());
            } else {
                this.messageTracker.revertCurrentState();
            }
        }
    }

    Map<ComponentLocation, ConnectableComponentModel> getUpdatedModels() {
        return this.updatedModels;
    }

    private ExpressionLanguageMetadataService.MessageCallback createMessageCallback(final List<String> errorsReference) {
        return new ExpressionLanguageMetadataService.MessageCallback(){

            public void warning(String s, ExpressionLanguageMetadataService.MessageLocation messageLocation) {
            }

            public void error(String s, ExpressionLanguageMetadataService.MessageLocation messageLocation) {
                errorsReference.add(s);
            }
        };
    }

    public boolean wasSuccessfulPropagation() {
        return this.success;
    }

    private boolean isMinimizedPropagation() {
        return false;
    }
}

