/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.framework.api.tooling.type.propagation.TypedEventField;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.util.Preconditions;

public class TypedEventFieldBuilder {
    private ComponentLocation declaration;
    private final List<ComponentLocation> usages = new ArrayList<ComponentLocation>();
    private MetadataType metadataType;
    private TypedEventField built = null;

    public TypedEventFieldBuilder withDeclarationIn(ComponentLocation location) {
        this.declaration = location;
        this.usages.add(location);
        return this;
    }

    public TypedEventFieldBuilder withUsage(ComponentLocation location) {
        this.usages.add(location);
        return this;
    }

    public TypedEventFieldBuilder withMetadataType(MetadataType type) {
        this.metadataType = type;
        return this;
    }

    public boolean isType(MetadataType type) {
        return this.metadataType.equals(type);
    }

    public TypedEventField build() {
        if (this.built != null) {
            return this.built;
        }
        Preconditions.checkState((this.metadataType != null ? 1 : 0) != 0, (String)"There must be a metadata type defined");
        this.built = new DefaultTypedEventField(this.declaration, this.usages, this.metadataType);
        return this.built;
    }

    private static class DefaultTypedEventField
    implements TypedEventField {
        private final Optional<ComponentLocation> declaration;
        private final List<ComponentLocation> usages;
        private final MetadataType metadataType;

        public DefaultTypedEventField(ComponentLocation declaration, List<ComponentLocation> usages, MetadataType type) {
            this.declaration = Optional.ofNullable(declaration);
            this.usages = usages;
            this.metadataType = type;
        }

        public Optional<ComponentLocation> getDeclarationLocation() {
            return this.declaration;
        }

        public List<ComponentLocation> getUsages() {
            return this.usages;
        }

        public MetadataType getType() {
            return this.metadataType;
        }
    }
}

