/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.framework.api.tooling.type.propagation.TypePropagationResult;
import org.mule.framework.api.tooling.type.propagation.TypedChainComponent;
import org.mule.framework.api.tooling.type.propagation.TypedEventField;
import org.mule.framework.internal.tooling.type.propagation.TypedEventFieldBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.i18n.I18nMessage;

public final class DefaultTypePropagationResult
implements TypePropagationResult {
    private final boolean success;
    private final Map<ComponentLocation, TypedChainComponent> info;
    private final List<I18nMessage> failures;

    private DefaultTypePropagationResult(boolean success, Map<ComponentLocation, TypedChainComponent> info, List<I18nMessage> failures) {
        this.success = success;
        this.info = info;
        this.failures = failures;
    }

    public static DefaultTypePropagationResult success(Map<ComponentLocation, TypedChainComponent> info) {
        return new DefaultTypePropagationResult(true, info, Collections.emptyList());
    }

    public static DefaultTypePropagationResult failure(List<I18nMessage> errorMessages) {
        return new DefaultTypePropagationResult(false, null, errorMessages);
    }

    public boolean isValid() {
        return this.success;
    }

    private static TypedEventField metadataTypeToTypedEventField(ComponentLocation location, MetadataType type) {
        return new TypedEventFieldBuilder().withMetadataType(type).withDeclarationIn(location).build();
    }

    public Optional<TypedChainComponent> getTypedComponent(ComponentLocation location) {
        if (!this.isValid() || !this.info.containsKey(location)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.info.get(location));
    }

    public List<I18nMessage> failureMessages() {
        return this.failures;
    }
}

