/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.sample.data;

import com.google.common.base.Throwables;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.framework.api.extension.config.ConfigurationHandler;
import org.mule.framework.internal.streaming.NullStreamingManager;
import org.mule.framework.internal.util.MuleFrameworkUtils;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.parameter.ActingParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.sampledata.SampleDataFailure;
import org.mule.runtime.api.sampledata.SampleDataResult;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.module.extension.internal.data.sample.SampleDataProviderMediator;
import org.mule.runtime.module.extension.internal.runtime.config.ResolverSetBasedParameterResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleDataExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SampleDataExecutor.class);
    private final MuleContext muleContext;
    private final ExpressionManager expressionManager;
    private final ReflectionCache reflectionCache;

    public SampleDataExecutor(MuleContext muleContext, ExpressionManager expressionManager, ReflectionCache reflectionCache) {
        this.muleContext = muleContext;
        this.expressionManager = expressionManager;
        this.reflectionCache = reflectionCache;
    }

    public SampleDataResult getSampleData(ExtensionModel extensionModel, ComponentParameterization parameters, Optional<ConfigurationHandler> configurationHandler) {
        try {
            ClassLoader extensionClassLoader = MuleExtensionUtils.getClassLoader((ExtensionModel)extensionModel);
            return (SampleDataResult)ClassUtils.withContextClassLoader((ClassLoader)extensionClassLoader, () -> {
                if (!(parameters.getModel() instanceof ComponentModel) || !(parameters.getModel() instanceof HasOutputModel)) {
                    String message = String.format("Component '%s' does not support Sample Data", parameters.getModel().getName());
                    return SampleDataResult.resultFrom((SampleDataFailure)SampleDataFailure.Builder.newFailure().withMessage(message).withReason(message).withFailureCode("NOT_SUPPORTED").build());
                }
                ComponentModel componentModel = (ComponentModel)parameters.getModel();
                ComponentParameterization paramWithDefaultValues = this.getParametersWithDefaultValues(componentModel, parameters);
                ResolverSet resolverSet = ResolverSetUtils.getResolverSetFromComponentParameterization((ComponentParameterization)paramWithDefaultValues, (MuleContext)this.muleContext, (boolean)true, (ReflectionCache)this.reflectionCache, (ExpressionManager)this.expressionManager, (String)parameters.getModel().getName());
                ResolverSetBasedParameterResolver parameterValueResolver = new ResolverSetBasedParameterResolver(resolverSet, (ParameterizedModel)componentModel, this.reflectionCache, this.expressionManager);
                Supplier<Object> connectionSupplier = MuleFrameworkUtils.connectionSupplier(configurationHandler, this.muleContext);
                SampleDataProviderMediator sampleDataProviderMediator = new SampleDataProviderMediator(extensionModel, componentModel, (Component)new NullComponent(extensionModel.getName(), componentModel.getName()), this.muleContext, this.reflectionCache, (StreamingManager)NullStreamingManager.NULL_STREAMING_MANAGER_INSTANCE);
                return SampleDataResult.resultFrom((Message)sampleDataProviderMediator.getSampleData((ParameterValueResolver)parameterValueResolver, connectionSupplier, MuleFrameworkUtils.configSupplier(configurationHandler, this.muleContext), () -> MuleFrameworkUtils.getConnectionProvider(configurationHandler, this.muleContext).orElse(null)));
            }, SampleDataException.class, e -> {
                throw new MuleRuntimeException((Throwable)e);
            });
        }
        catch (SampleDataException e2) {
            LOGGER.warn(String.format("Get sample data has FAILED with code: %s for component: %s", e2.getFailureCode(), parameters.getModel().getName()), (Throwable)e2);
            return SampleDataResult.resultFrom((SampleDataFailure)SampleDataFailure.Builder.newFailure((Throwable)e2).withFailureCode(e2.getFailureCode()).build());
        }
        catch (MuleRuntimeException e3) {
            Throwable cause = e3.getCause();
            if (cause instanceof SampleDataException) {
                SampleDataException sampleDataException = (SampleDataException)cause;
                LOGGER.warn(String.format("Get sample data has FAILED with code: %s for component: %s", sampleDataException.getFailureCode(), parameters.getModel().getName()), (Throwable)e3);
                SampleDataFailure.Builder failureBuilder = SampleDataFailure.Builder.newFailure((Throwable)cause);
                failureBuilder.withFailureCode(sampleDataException.getFailureCode());
                return SampleDataResult.resultFrom((SampleDataFailure)failureBuilder.build());
            }
            Throwables.propagateIfPossible((Throwable)cause, MuleRuntimeException.class);
            throw new MuleRuntimeException(cause);
        }
        catch (Exception e4) {
            Throwables.propagateIfPossible((Throwable)e4, MuleRuntimeException.class);
            throw new MuleRuntimeException((Throwable)e4);
        }
    }

    private ComponentParameterization getParametersWithDefaultValues(ComponentModel componentModel, ComponentParameterization parameters) {
        return ((HasOutputModel)componentModel).getSampleDataProviderModel().map(model -> {
            List actingParameters = model.getParameters().stream().map(ActingParameterModel::getName).collect(Collectors.toList());
            List<Pair> defaultValues = componentModel.getParameterGroupModels().stream().flatMap(group -> group.getParameterModels().stream().filter(p -> actingParameters.contains(p.getName()) && parameters.getParameter(group.getName(), p.getName()) == null && !p.isRequired() && p.getDefaultValue() != null).map(p -> new Pair(group, p))).collect(Collectors.toList());
            if (defaultValues.isEmpty()) {
                return parameters;
            }
            ComponentParameterization.Builder parametersWithDefaultValues = ComponentParameterization.builder((ParameterizedModel)parameters.getModel());
            parameters.forEachParameter((group, param, value) -> parametersWithDefaultValues.withParameter(param.getName(), value));
            defaultValues.forEach(value -> parametersWithDefaultValues.withParameter(((ParameterGroupModel)value.getFirst()).getName(), ((ParameterModel)value.getSecond()).getName(), ((ParameterModel)value.getSecond()).getDefaultValue()));
            return parametersWithDefaultValues.build();
        }).orElse(parameters);
    }

    private static class NullComponent
    extends AbstractComponent {
        private final ComponentLocation location;

        public NullComponent(String extensionName, String componentName) {
            this.location = DefaultComponentLocation.from((String)(extensionName + "/" + componentName));
        }

        public ComponentLocation getLocation() {
            return this.location;
        }

        public Location getRootContainerLocation() {
            return Location.builder().globalName(this.location.getLocation()).build();
        }
    }
}

