/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.service;

import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.framework.internal.service.AbstractServiceLifecycleProxyInvocationHandler;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.service.api.manager.ServiceRegistry;

public class SharedServiceLifecycleProxyInvocationHandler
extends AbstractServiceLifecycleProxyInvocationHandler {
    private static Optional<Boolean> keepServicesAlive = Optional.empty();
    private final ServiceRegistry registry;
    private final Class<? extends Service> serviceContract;
    private final WeakReference<ArtifactClassLoader> serviceClassLoader;
    private final Service service;
    private final AtomicInteger currentUsers = new AtomicInteger();

    public static void keepServicesAlive(Boolean keep) {
        keepServicesAlive = Optional.ofNullable(keep);
    }

    public static boolean isKeepServicesAlive() {
        return keepServicesAlive.orElse(Boolean.getBoolean("mule.framework.keepServicesAliveAfterLastFrameworkClosed"));
    }

    public SharedServiceLifecycleProxyInvocationHandler(ServiceRegistry registry, Class<? extends Service> serviceContract, ArtifactClassLoader serviceClassLoader, Service service) {
        this.registry = registry;
        this.serviceContract = serviceContract;
        this.serviceClassLoader = new WeakReference<ArtifactClassLoader>(serviceClassLoader);
        this.service = service;
    }

    @Override
    public synchronized Object handleStart() throws MuleException {
        if (this.currentUsers.getAndIncrement() == 0 && this.getService() instanceof Startable) {
            ((Startable)this.getService()).start();
        }
        return null;
    }

    @Override
    public synchronized Object handleStop() throws MuleException {
        if (this.currentUsers.decrementAndGet() == 0 && !SharedServiceLifecycleProxyInvocationHandler.isKeepServicesAlive()) {
            this.forceStop();
        }
        return null;
    }

    public synchronized void forceStop() throws MuleException {
        if (this.getService() instanceof Stoppable) {
            ((Stoppable)this.getService()).stop();
        }
        this.registry.unregister(this.serviceContract);
        ((ArtifactClassLoader)this.serviceClassLoader.get()).dispose();
    }

    @Override
    public synchronized Service getService() {
        return this.service;
    }
}

