/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.extension.connection.parser;

import java.util.Collection;
import java.util.Optional;
import org.mule.framework.api.extension.connection.fluent.ConnectionConfigurer;
import org.mule.framework.api.extension.connection.fluent.PoolingProfileConfigurer;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.tls.TlsContextFactoryBuilder;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantTypeVisitor;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthModelProperty;
import org.mule.runtime.extension.api.connectivity.oauth.PlatformManagedOAuthGrantType;

public class DietConnectionParserUtils {
    private static final String COUNT = "count";
    private static final String FREQUENCY = "frequency";
    private static final String RECONNECT_ALIAS = "reconnect";
    private static final String RECONNECT_FOREVER_ALIAS = "reconnect-forever";
    private static final String BLOCKING = "blocking";
    private static final String RECONNECTION_CONFIG = "Reconnection";
    private static final String FAILS_DEPLOYMENT_PARAMETER_NAME = "failsDeployment";
    private static final String UNKNOWN = "UNKNOWN";
    private static final String MAX_ACTIVE = "maxActive";
    private static final String MAX_IDLE = "maxIdle";
    private static final String INITIALISATION_POLICY = "initialisationPolicy";
    private static final String EXHAUSTED_ACTION = "exhaustedAction";
    private static final String MAX_WAIT = "maxWait";
    private static final String MIN_EVICTION_MILLIS = "minEvictionMillis";
    private static final String EVICTION_CHECK_INTERVAL_MILLIS = "evictionCheckIntervalMillis";
    private static final String TLS_GROUP_NAME = "Tls";
    private static final String TLS_TRUST_STORE_GROUP_NAME = "TrustStore";
    private static final String TLS_KEY_STORE_GROUP_NAME = "KeyStore";
    private static final String TLS_TRUST_STORE_PATH_PARAMETER_NAME = "path";
    private static final String TLS_TRUST_STORE_PASSWORD_PARAMETER_NAME = "password";
    private static final String TLS_TRUST_STORE_TYPE_PARAMETER_NAME = "type";
    private static final String TLS_TRUST_STORE_ALGORITHM_PARAMETER_NAME = "algorithm";
    private static final String TLS_TRUST_STORE_INSECURE_PARAMETER_NAME = "insecure";
    private static final String TLS_KEY_STORE_PATH_PARAMETER_NAME = "path";
    private static final String TLS_KEY_STORE_PASSWORD_PARAMETER_NAME = "password";
    private static final String TLS_KEY_STORE_KEY_PASSWORD_PARAMETER_NAME = "keyPassword";
    private static final String TLS_KEY_STORE_TYPE_PARAMETER_NAME = "type";
    private static final String TLS_KEY_STORE_ALGORITHM_PARAMETER_NAME = "algorithm";
    private static final String TLS_KEY_STORE_ALIAS_PARAMETER_NAME = "alias";

    private DietConnectionParserUtils() {
    }

    public static void parseOAuthConfigFromParameterization(final ConnectionConfigurer connectionConfigurer, final ComponentParameterization<ParameterizedModel> connectionParameterization, ConnectionProviderModel connectionModel, final Collection<Pair<String, Optional<String>>> alreadyProcessedParameters) {
        if (connectionModel.getModelProperty(OAuthModelProperty.class).isPresent()) {
            OAuthGrantType grantType = (OAuthGrantType)((OAuthModelProperty)connectionModel.getModelProperty(OAuthModelProperty.class).get()).getGrantTypes().get(0);
            grantType.accept(new OAuthGrantTypeVisitor(){

                public void visit(AuthorizationCodeGrantType grantType) {
                    connectionConfigurer.withAuthorizationCodeOAuth().credentials((String)this.getAuthCodeParam((ComponentParameterization<ParameterizedModel>)connectionParameterization, "consumerKey"), (String)this.getAuthCodeParam((ComponentParameterization<ParameterizedModel>)connectionParameterization, "consumerSecret")).authorizationUrl((String)this.getAuthCodeParam((ComponentParameterization<ParameterizedModel>)connectionParameterization, "authorizationUrl")).accessTokenUrl((String)this.getAuthCodeParam((ComponentParameterization<ParameterizedModel>)connectionParameterization, "accessTokenUrl")).scopes(this.parseScopes((String)this.getAuthCodeParam((ComponentParameterization<ParameterizedModel>)connectionParameterization, "scopes"))).resourceOwnerId((String)this.getAuthCodeParam((ComponentParameterization<ParameterizedModel>)connectionParameterization, "resourceOwnerId")).httpListenerRef((String)this.getCallbackParam((ComponentParameterization<ParameterizedModel>)connectionParameterization, "listenerConfig")).callbackPath((String)this.getCallbackParam((ComponentParameterization<ParameterizedModel>)connectionParameterization, "callbackPath")).authorizePath((String)this.getCallbackParam((ComponentParameterization<ParameterizedModel>)connectionParameterization, "authorizePath")).externalCallbackPath((String)this.getCallbackParam((ComponentParameterization<ParameterizedModel>)connectionParameterization, "externalCallbackUrl")).objectStore((ObjectStore)connectionParameterization.getParameter("oauthStoreConfig", "objectStore"));
                    alreadyProcessedParameters.add(new Pair((Object)"oauthAuthorizationCode", Optional.empty()));
                    alreadyProcessedParameters.add(new Pair((Object)"oauthCallbackConfig", Optional.empty()));
                    alreadyProcessedParameters.add(new Pair((Object)"oauthStoreConfig", Optional.empty()));
                }

                private <T> T getAuthCodeParam(ComponentParameterization<ParameterizedModel> connectionParameterization2, String paramName) {
                    return (T)connectionParameterization2.getParameter("oauthAuthorizationCode", paramName);
                }

                private <T> T getCallbackParam(ComponentParameterization<ParameterizedModel> connectionParameterization2, String paramName) {
                    return (T)connectionParameterization2.getParameter("oauthCallbackConfig", paramName);
                }

                public void visit(ClientCredentialsGrantType grantType) {
                    connectionConfigurer.withClientCredentialsOAuth().credentials((String)this.getClientCredentialsParam((ComponentParameterization<ParameterizedModel>)connectionParameterization, "clientId"), (String)this.getClientCredentialsParam((ComponentParameterization<ParameterizedModel>)connectionParameterization, "clientSecret")).tokenUrl((String)this.getClientCredentialsParam((ComponentParameterization<ParameterizedModel>)connectionParameterization, "tokenUrl")).scopes(this.parseScopes((String)this.getClientCredentialsParam((ComponentParameterization<ParameterizedModel>)connectionParameterization, "scopes"))).objectStore((ObjectStore)connectionParameterization.getParameter("oauthStoreConfig", "objectStore"));
                    alreadyProcessedParameters.add(new Pair((Object)"oauthClientCredentials", Optional.empty()));
                    alreadyProcessedParameters.add(new Pair((Object)"oauthStoreConfig", Optional.empty()));
                }

                private <T> T getClientCredentialsParam(ComponentParameterization<ParameterizedModel> connectionParameterization2, String paramName) {
                    return (T)connectionParameterization2.getParameter("oauthClientCredentials", paramName);
                }

                private String[] parseScopes(String scopes) {
                    return scopes != null ? scopes.split(" ") : null;
                }

                public void visit(PlatformManagedOAuthGrantType grantType) {
                    connectionConfigurer.withPlatformManagedOAuth().connectionId((String)connectionParameterization.getParameter("General", "connectionId"));
                    alreadyProcessedParameters.add(new Pair((Object)"General", Optional.of("connectionId")));
                }
            });
        }
    }

    public static void parseReconnectionConfigFromParameterization(ConnectionConfigurer connectionConfigurer, ComponentParameterization<ParameterizedModel> connectionParameterization, Collection<Pair<String, Optional<String>>> alreadyProcessedParameters, String configName) {
        String connectionName = connectionParameterization.getComponentIdentifier().map(ComponentIdentifier::getName).orElse(UNKNOWN);
        ComponentParameterization reconnection = (ComponentParameterization)connectionParameterization.getParameter("Connection", "reconnection");
        if (reconnection != null) {
            ComponentParameterization reconnectionStrategy = (ComponentParameterization)reconnection.getParameter(RECONNECTION_CONFIG, "reconnectionStrategy");
            if (reconnectionStrategy != null) {
                String reconnectionType = ((ComponentIdentifier)reconnectionStrategy.getComponentIdentifier().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Unknown reconnection type for connection '%s' from config '%s'", connectionName, configName))))).getName();
                boolean failsDeployment = (Boolean)reconnection.getParameter(RECONNECTION_CONFIG, FAILS_DEPLOYMENT_PARAMETER_NAME);
                if (reconnectionType.equals(RECONNECT_ALIAS)) {
                    DietConnectionParserUtils.configureSimpleReconnection(connectionConfigurer, (ComponentParameterization<ParameterizedModel>)reconnectionStrategy, failsDeployment);
                } else if (reconnectionType.equals(RECONNECT_FOREVER_ALIAS)) {
                    DietConnectionParserUtils.configureForeverReconnection(connectionConfigurer, (ComponentParameterization<ParameterizedModel>)reconnectionStrategy, failsDeployment);
                } else {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Unknown reconnection type for connection '%s' from config '%s'", connectionName, configName)));
                }
            }
            alreadyProcessedParameters.add((Pair<String, Optional<String>>)new Pair((Object)"Connection", Optional.of("reconnection")));
        }
    }

    private static void configureSimpleReconnection(ConnectionConfigurer connection, ComponentParameterization<ParameterizedModel> reconnectionStrategy, boolean failsDeployment) {
        boolean blocking = (Boolean)reconnectionStrategy.getParameter(RECONNECT_ALIAS, BLOCKING);
        long frequency = (Long)reconnectionStrategy.getParameter(RECONNECT_ALIAS, FREQUENCY);
        int count = (Integer)reconnectionStrategy.getParameter(RECONNECT_ALIAS, COUNT);
        connection.withSimpleReconnection(failsDeployment, blocking).frequency((int)frequency).count(count);
    }

    private static void configureForeverReconnection(ConnectionConfigurer connection, ComponentParameterization<ParameterizedModel> reconnectionStrategy, boolean failsDeployment) {
        boolean blocking = (Boolean)reconnectionStrategy.getParameter(RECONNECT_FOREVER_ALIAS, BLOCKING);
        long frequency = (Long)reconnectionStrategy.getParameter(RECONNECT_FOREVER_ALIAS, FREQUENCY);
        connection.withReconnectForeverStrategy(failsDeployment, blocking).frequency((int)frequency);
    }

    public static void parsePoolingProfileConfigFromParameterization(ConnectionConfigurer connectionConfigurer, ComponentParameterization<ParameterizedModel> connectionParameterization, Collection<Pair<String, Optional<String>>> alreadyProcessedParameters) {
        ComponentParameterization poolingProfile = (ComponentParameterization)connectionParameterization.getParameter("Connection", "poolingProfile");
        if (poolingProfile != null) {
            Object maxActive = poolingProfile.getParameter("pooling-profile", MAX_ACTIVE);
            Object maxIdle = poolingProfile.getParameter("pooling-profile", MAX_IDLE);
            Object initialisationPolicy = poolingProfile.getParameter("pooling-profile", INITIALISATION_POLICY);
            Object exhaustedAction = poolingProfile.getParameter("pooling-profile", EXHAUSTED_ACTION);
            Object maxWait = poolingProfile.getParameter("pooling-profile", MAX_WAIT);
            Object minEvictionMillis = poolingProfile.getParameter("pooling-profile", MIN_EVICTION_MILLIS);
            Object intervalMillis = poolingProfile.getParameter("pooling-profile", EVICTION_CHECK_INTERVAL_MILLIS);
            PoolingProfileConfigurer configurer = connectionConfigurer.withPoolingProfile();
            if (maxActive != null) {
                configurer.maxActive(((Integer)maxActive).intValue());
            }
            if (maxIdle != null) {
                configurer.maxIdle(((Integer)maxIdle).intValue());
            }
            if (initialisationPolicy != null) {
                configurer.initialisationPolicy(PoolingProfileConfigurer.InitialisationPolicy.valueOf((String)((String)initialisationPolicy)));
            }
            if (exhaustedAction != null) {
                configurer.exhaustedAction(PoolingProfileConfigurer.ExhaustedAction.valueOf((String)((String)exhaustedAction)));
            }
            if (maxWait != null) {
                configurer.maxWait(((Long)maxWait).longValue());
            }
            if (minEvictionMillis != null) {
                configurer.minEvictionMillis(((Integer)minEvictionMillis).intValue());
            }
            if (intervalMillis != null) {
                configurer.evictionCheckIntervalMillis(((Integer)intervalMillis).intValue());
            }
            alreadyProcessedParameters.add((Pair<String, Optional<String>>)new Pair((Object)"Connection", Optional.of("poolingProfile")));
        }
    }

    public static void parseTlsConfigFromParameterization(ConnectionConfigurer connectionConfigurer, ComponentParameterization<ParameterizedModel> connectionParameterization, Collection<Pair<String, Optional<String>>> alreadyProcessedParameters) {
        ComponentParameterization tlsContext = (ComponentParameterization)connectionParameterization.getParameter("General", "tlsContext");
        if (tlsContext != null) {
            TlsContextFactoryBuilder tlsContextFactoryBuilder = connectionConfigurer.withTls();
            DietConnectionParserUtils.configureTrustStore((ComponentParameterization<ParameterizedModel>)tlsContext, tlsContextFactoryBuilder);
            DietConnectionParserUtils.configureKeyStore((ComponentParameterization<ParameterizedModel>)tlsContext, tlsContextFactoryBuilder);
            alreadyProcessedParameters.add((Pair<String, Optional<String>>)new Pair((Object)"General", Optional.of("tlsContext")));
        }
    }

    private static void configureTrustStore(ComponentParameterization<ParameterizedModel> tlsContext, TlsContextFactoryBuilder tlsContextFactoryBuilder) {
        ComponentParameterization trustStore = (ComponentParameterization)tlsContext.getParameter(TLS_GROUP_NAME, "trust-store");
        if (trustStore != null) {
            Object path = trustStore.getParameter(TLS_TRUST_STORE_GROUP_NAME, "path");
            Object password = trustStore.getParameter(TLS_TRUST_STORE_GROUP_NAME, "password");
            Object type = trustStore.getParameter(TLS_TRUST_STORE_GROUP_NAME, "type");
            Object algorithm = trustStore.getParameter(TLS_TRUST_STORE_GROUP_NAME, "algorithm");
            Object insecure = trustStore.getParameter(TLS_TRUST_STORE_GROUP_NAME, TLS_TRUST_STORE_INSECURE_PARAMETER_NAME);
            if (path != null) {
                tlsContextFactoryBuilder.trustStorePath((String)path);
            }
            if (password != null) {
                tlsContextFactoryBuilder.trustStorePassword((String)password);
            }
            if (type != null) {
                tlsContextFactoryBuilder.trustStoreType((String)type);
            }
            if (algorithm != null) {
                tlsContextFactoryBuilder.trustStoreAlgorithm((String)algorithm);
            }
            if (insecure != null) {
                tlsContextFactoryBuilder.insecureTrustStore(((Boolean)insecure).booleanValue());
            }
        }
    }

    private static void configureKeyStore(ComponentParameterization<ParameterizedModel> tlsContext, TlsContextFactoryBuilder tlsContextFactoryBuilder) {
        ComponentParameterization keyStore = (ComponentParameterization)tlsContext.getParameter(TLS_GROUP_NAME, "key-store");
        if (keyStore != null) {
            Object path = keyStore.getParameter(TLS_KEY_STORE_GROUP_NAME, "path");
            Object password = keyStore.getParameter(TLS_KEY_STORE_GROUP_NAME, "password");
            Object keyPassword = keyStore.getParameter(TLS_KEY_STORE_GROUP_NAME, TLS_KEY_STORE_KEY_PASSWORD_PARAMETER_NAME);
            Object type = keyStore.getParameter(TLS_KEY_STORE_GROUP_NAME, "type");
            Object algorithm = keyStore.getParameter(TLS_KEY_STORE_GROUP_NAME, "algorithm");
            Object alias = keyStore.getParameter(TLS_KEY_STORE_GROUP_NAME, TLS_KEY_STORE_ALIAS_PARAMETER_NAME);
            if (path != null) {
                tlsContextFactoryBuilder.keyStorePath((String)path);
            }
            if (password != null) {
                tlsContextFactoryBuilder.keyStorePassword((String)password);
            }
            if (keyPassword != null) {
                tlsContextFactoryBuilder.keyPassword((String)keyPassword);
            }
            if (type != null) {
                tlsContextFactoryBuilder.keyStoreType((String)type);
            }
            if (algorithm != null) {
                tlsContextFactoryBuilder.keyStoreAlgorithm((String)algorithm);
            }
            if (alias != null) {
                tlsContextFactoryBuilder.keyAlias((String)alias);
            }
        }
    }
}

