/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.extension.connection.fluent;

import org.mule.framework.api.extension.connection.fluent.AuthorizationCodeOAuthConfigurer;
import org.mule.framework.api.extension.connection.fluent.ClientCredentialsOAuthConfigurer;
import org.mule.framework.api.extension.connection.fluent.ConnectionConfigurer;
import org.mule.framework.api.extension.connection.fluent.PlatformManagedOAuthConfigurer;
import org.mule.framework.api.extension.connection.fluent.PoolingProfileConfigurer;
import org.mule.framework.api.extension.connection.fluent.ReconnectForeverConfigurer;
import org.mule.framework.api.extension.connection.fluent.SimpleReconnectionConfigurer;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.extension.connection.fluent.DietOAuthParameterizer;
import org.mule.framework.internal.extension.connection.fluent.DietPoolingProfile;
import org.mule.framework.internal.extension.connection.fluent.reconnect.AbstractReconnectionConfigurer;
import org.mule.framework.internal.extension.connection.fluent.reconnect.ReconnectForever;
import org.mule.framework.internal.extension.connection.fluent.reconnect.SimpleReconnection;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextFactoryBuilder;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.retry.ReconnectionConfig;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.module.extension.internal.runtime.config.ConfigurationCreationUtils;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ConnectionProviderSettings;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderResolver;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public class DietConnectionConfigurer
implements ConnectionConfigurer {
    private final ExtensionModel extensionModel;
    private final ConnectionProviderModel connectionProviderModel;
    private final InternalMuleFramework muleFramework;
    private final ComponentParameterization.Builder<ConnectionProviderModel> component;
    private TlsContextFactoryBuilder tlsContextFactoryBuilder;
    private AbstractReconnectionConfigurer reconnectionParameterizer;
    private DietPoolingProfile poolingProfileParameterizer;
    private DietOAuthParameterizer oauthParameterizer;

    public DietConnectionConfigurer(ExtensionModel extensionModel, ConnectionProviderModel connectionProviderModel, InternalMuleFramework muleFramework) {
        this.extensionModel = extensionModel;
        this.connectionProviderModel = connectionProviderModel;
        this.muleFramework = muleFramework;
        this.component = ComponentParameterization.builder((ParameterizedModel)connectionProviderModel);
    }

    public ConnectionProviderResolver asValueResolver() throws MuleException {
        ConnectionProviderSettings settings = new ConnectionProviderSettings(this.connectionProviderModel, this.collectParameters(), this.getPoolingProfile(), this.getReconnectionConfig(), this.muleFramework.getAuthorizationCodeOAuthHandler(), this.muleFramework.getClientCredentialsOAuthHandler(), this.muleFramework.getPlatformManagedOAuthHandler());
        return ConfigurationCreationUtils.createConnectionProviderResolver((ExtensionModel)this.extensionModel, (ConnectionProviderSettings)settings, (ConfigurationProperties)this.muleFramework.getConfigurationProperties(), (ExpressionManager)this.muleFramework.getExpressionManager(), (ReflectionCache)this.muleFramework.getReflectionCache(), (String)"", (DslSyntaxResolver)this.muleFramework.getDslSyntaxResolver(this.extensionModel), (MuleContext)this.muleFramework.getMuleContext());
    }

    private ComponentParameterization<ConnectionProviderModel> collectParameters() {
        if (this.oauthParameterizer != null) {
            this.oauthParameterizer.configure(this.component);
        }
        if (this.tlsContextFactoryBuilder != null) {
            try {
                this.component.withParameter("tlsContext", (Object)this.tlsContextFactoryBuilder.build());
            }
            catch (CreateException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not create TLS context: " + e.getMessage())), (Throwable)e);
            }
        }
        return this.component.build();
    }

    private PoolingProfile getPoolingProfile() {
        return this.poolingProfileParameterizer != null ? this.poolingProfileParameterizer.toPoolingProfile() : null;
    }

    private ReconnectionConfig getReconnectionConfig() {
        return this.reconnectionParameterizer != null ? this.reconnectionParameterizer.toReconnectionConfig() : null;
    }

    public ConnectionConfigurer withParameter(String parameter, Object value) {
        this.component.withParameter(parameter, value);
        return this;
    }

    public ConnectionConfigurer withParameter(String parameterGroup, String parameter, Object value) {
        this.component.withParameter(parameterGroup, parameter, value);
        return this;
    }

    public TlsContextFactoryBuilder withTls() {
        this.tlsContextFactoryBuilder = TlsContextFactory.builder();
        return this.tlsContextFactoryBuilder;
    }

    public SimpleReconnectionConfigurer withSimpleReconnection(boolean failsCreation, boolean blocking) {
        this.reconnectionParameterizer = new SimpleReconnection(failsCreation, blocking);
        return (SimpleReconnectionConfigurer)this.reconnectionParameterizer;
    }

    public ReconnectForeverConfigurer withReconnectForeverStrategy(boolean failsCreation, boolean blocking) {
        this.reconnectionParameterizer = new ReconnectForever(failsCreation, blocking);
        return (ReconnectForeverConfigurer)this.reconnectionParameterizer;
    }

    public PoolingProfileConfigurer withPoolingProfile() {
        this.poolingProfileParameterizer = new DietPoolingProfile();
        return this.poolingProfileParameterizer;
    }

    public AuthorizationCodeOAuthConfigurer withAuthorizationCodeOAuth() {
        DietOAuthParameterizer.DietAuthorizationCodeOAuthConfigurer oauth = new DietOAuthParameterizer.DietAuthorizationCodeOAuthConfigurer();
        this.oauthParameterizer = oauth;
        return oauth;
    }

    public ClientCredentialsOAuthConfigurer withClientCredentialsOAuth() {
        DietOAuthParameterizer.DietClientCredentialsOAuthConfigurer oauth = new DietOAuthParameterizer.DietClientCredentialsOAuthConfigurer();
        this.oauthParameterizer = oauth;
        return oauth;
    }

    public PlatformManagedOAuthConfigurer withPlatformManagedOAuth() {
        DietOAuthParameterizer.DietPlatformManagerOAuthConfigurer oauth = new DietOAuthParameterizer.DietPlatformManagerOAuthConfigurer();
        this.oauthParameterizer = oauth;
        return oauth;
    }
}

