/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.extension;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.mule.framework.api.execution.MuleExecutionFramework;
import org.mule.framework.api.extension.operation.fluent.OperationCommand;
import org.mule.framework.api.extension.source.SourceHandler;
import org.mule.framework.api.extension.source.SourceResultHandler;
import org.mule.framework.api.extension.source.fluent.SourceCreationCommand;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.extension.operation.fluent.DietOperationCommand;
import org.mule.framework.internal.extension.source.DietSourceHandlerAdapter;
import org.mule.framework.internal.extension.source.DietSourceResultHandlerAdapter;
import org.mule.framework.internal.extension.source.fluent.DietSourceCreationCommand;
import org.mule.framework.internal.util.MuleFrameworkUtils;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class DietMuleExecutionFramework
implements MuleExecutionFramework {
    private final InternalMuleFramework muleFramework;
    private final ExtensionsClient extensionsClient;

    public DietMuleExecutionFramework(InternalMuleFramework muleFramework) {
        this.muleFramework = muleFramework;
        this.extensionsClient = muleFramework.getExtensionsClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, A> CompletableFuture<Result<T, A>> executeOperation(String extensionName, Consumer<OperationCommand> command) {
        MuleFrameworkUtils.assertExtensionModelLoader(this.muleFramework, extensionName);
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        DietOperationCommand request = new DietOperationCommand(this.muleFramework);
        command.accept(request);
        currentThread.setContextClassLoader(this.muleFramework.getExecutionClassLoader());
        try {
            CompletableFuture completableFuture = this.extensionsClient.execute(extensionName, request.getOperationName(), request::parameterize);
            return completableFuture;
        }
        finally {
            currentThread.setContextClassLoader(originalClassLoader);
        }
    }

    public <T, A> SourceHandler createSource(String extensionName, Consumer<SourceCreationCommand> command, Consumer<SourceResultHandler<T, A>> sourceResultHandlerConsumer) {
        MuleFrameworkUtils.assertExtensionModelLoader(this.muleFramework, extensionName);
        DietSourceCreationCommand request = new DietSourceCreationCommand(this.muleFramework);
        command.accept(request);
        return new DietSourceHandlerAdapter(this.extensionsClient.createSource(extensionName, request.getSourceName(), h -> sourceResultHandlerConsumer.accept(new DietSourceResultHandlerAdapter(h)), request::parameterize));
    }
}

